<?php
$markers = array(
    'default' => array(
        'path' => '<path d="M0,0v14h14V0H0z M12,12H2V2h10V12z"/>',
        'rotate' => false,
    ),
    'flurry' => array(
        'path' => '<path d="M0.2,0.1L0.1,0.6l0.1,0.5L0.2,1.6L0.1,2.1l0.1,0.5L0,3.1l0,0.5L0,4l0.1,0.5l0,0.5l0.1,0.5L0.1,6l0,0.5l0,0.5 l0.2,0.5L0.1,8l0.1,0.5L0,8.9l0.2,0.5L0,9.9l0.2,0.5l-0.1,0.5l0,0.5L0,11.9l0.2,0.5l-0.1,0.5l0.1,0.5l0,0.4L0.6,14l0.5,0l0.5-0.1 l0.5,0.1l0.5,0.1L3.1,14l0.5-0.1l0.5-0.1l0.5,0L5,13.9l0.5-0.1l0.5,0l0.5,0L7,13.9L7.5,14L8,14l0.5-0.2L9,13.9L9.4,14l0.5-0.2 l0.5,0.2l0.5-0.1l0.5,0l0.5-0.1l0.5,0l0.5,0l0.5,0l0.5,0.1l-0.1-0.5l0.2-0.5l-0.1-0.5l-0.1-0.5l0.2-0.5l-0.2-0.5l0.1-0.5L14,9.9 l-0.2-0.5L13.9,9L14,8.5L14,8l-0.2-0.5l0-0.5l0.1-0.5L13.8,6l0-0.5L14,5l0-0.5l-0.1-0.5l0.1-0.5l-0.2-0.5l0.1-0.5l0-0.5l0-0.5 l-0.1-0.5L14,0.6l-0.2-0.4l-0.4,0l-0.5,0L12.4,0l-0.5,0.2l-0.5,0l-0.5-0.1l-0.5,0L10,0l-0.5,0L9,0L8.5,0.2L8,0.2L7.5,0.1L7,0.1 L6.5,0.2L6,0L5.5,0.2L5.1,0.2L4.6,0.1L4.1,0.1L3.6,0L3.1,0.1L2.6,0L2.1,0.1l-0.5,0l-0.5,0L0.6,0.2L0.2,0.1z M11.9,11.9l-0.5-0.1 L10.9,12l-0.5-0.1L10,11.9l-0.5,0.1L9,11.8l-0.5,0l-0.5,0l-0.5,0.1l-0.5,0L6.5,12L6,11.9l-0.5,0l-0.5,0L4.6,12l-0.5-0.2L3.6,12 l-0.5-0.1L2.6,12l-0.4-0.1L2,11.4l0.1-0.5l0-0.5l0.1-0.5L2,9.5L2.1,9L2,8.5L2,8l0.2-0.5l0-0.5L2,6.5L2.1,6l0.1-0.5L2.2,5L2.1,4.5 L2,4.1l0-0.5l0.2-0.5L2,2.6L2,2l0.5,0l0.5,0.1l0.5,0.1l0.5,0L4.5,2L5,2.1l0.5,0.1L6,2l0.5,0.2L7,2.1l0.5,0L8,2l0.5,0L9,2l0.5,0 l0.5,0.1L10.4,2l0.5,0.2L11.4,2L12,2l-0.1,0.6L12,3.1l-0.1,0.5L11.8,4L12,4.5L11.9,5l-0.1,0.5l0,0.5L12,6.5L12,7l-0.1,0.5L12,8 l0,0.5l-0.2,0.5l0,0.5l0.1,0.5l-0.1,0.5l0.2,0.5l-0.1,0.5L11.9,11.9z"/>',
        'rotate' => false,
    ),
    'sdoz' => array(
        'path' => '<path d="M0,0l0.9,13c0,0.6,0.5,1,1,1h12V2c0-0.6-0.4-1-1-1L0,0z M12,12H3.8c-0.5,0-1-0.4-1-1L2,2l9,0.7c0.5,0,1,0.5,1,1 V12z"/>',
        'rotate' => true,
    ),
    'drop_in' => array(
        'path' => '<path d="M0,0l0,7c0,3.9,3.1,7,7,7h0c3.9,0,7-3.1,7-7v0c0-3.9-3.1-7-7-7H0z M7,12L7,12c-2.8,0-5-2.2-5-5V2h5c2.8,0,5,2.2,5,5v0 C12,9.8,9.8,12,7,12z"/>',
        'rotate' => true,
    ),
    'drop' => array(
        'path' => '<path d="M0,7L0,7c0,3.9,3.1,7,7,7h7V7c0-3.9-3.1-7-7-7h0C3.1,0,0,3.1,0,7z M12,12H7c-2.8,0-5-2.2-5-5v0c0-2.8,2.2-5,5-5h0 c2.8,0,5,2.2,5,5V12z"/>',
        'rotate' => true,
    ),
    'dropeye' => array(
        'path' => '<path d="M0,0l0,7c0,3.9,3.1,7,7,7h7V7c0-3.9-3.1-7-7-7H0z M12,12H7c-2.8,0-5-2.2-5-5V2h5c2.8,0,5,2.2,5,5V12z"/>',
        'rotate' => true,
    ),
    'dropeyeleft' => array(
        'path' => '<path d="M0,0l0,7c0,3.9,3.1,7,7,7h7V7c0-3.9-3.1-7-7-7H0z M12,12H7c-2.8,0-5-2.2-5-5v0c0-2.8,2.2-5,5-5h0c2.8,0,5,2.2,5,5V12z"/>',
        'rotate' => true,
    ),
    'dropeyeleaf' => array(
        'path' => '<path d="M0,0l0,7c0,3.9,3.1,7,7,7h7V7c0-3.9-3.1-7-7-7H0z M7,12L7,12c-2.8,0-5-2.2-5-5v0c0-2.8,2.2-5,5-5h0c2.8,0,5,2.2,5,5v0 C12,9.8,9.8,12,7,12z"/>',
        'rotate' => true,
    ),
    'dropeyeright' => array(
        'path' => '<path d="M0,0l0,7c0,3.9,3.1,7,7,7h7V7c0-3.9-3.1-7-7-7H0z M7,12L7,12c-2.8,0-5-2.2-5-5V2h5c2.8,0,5,2.2,5,5v0C12,9.8,9.8,12,7,12z"/>',
        'rotate' => true,
    ),
    'squarecircle' => array(
        'path' => '<path d="M0,0l0,14h14V0H0z M7,12L7,12c-2.8,0-5-2.2-5-5v0c0-2.8,2.2-5,5-5h0c2.8,0,5,2.2,5,5v0C12,9.8,9.8,12,7,12z"/>',
        'rotate' => false,
    ),
    'circle' => array(
        'path' => '<path d="M0,7L0,7c0,3.9,3.1,7,7,7h0c3.9,0,7-3.1,7-7v0c0-3.9-3.1-7-7-7h0C3.1,0,0,3.1,0,7z M7,12L7,12c-2.8,0-5-2.2-5-5v0 c0-2.8,2.2-5,5-5h0c2.8,0,5,2.2,5,5v0C12,9.8,9.8,12,7,12z"/>',
        'rotate' => false,
    ),
    'rounded' => array(
        'path' => '<path d="M4.5,14h5.1C12,14,14,12,14,9.6V4.5C14,2,12,0,9.5,0H4.4C2,0,0,2,0,4.4v5.1C0,12,2,14,4.5,14z M12,4.8v4.4 c0,1.5-1.3,2.8-2.8,2.8H4.8C3.2,12,2,10.8,2,9.2V4.8C2,3.3,3.3,2,4.8,2h4.4C10.8,2,12,3.2,12,4.8z"/>',
        'rotate' => false,
    ),
    'flower' => array(
        'path' => '<path d="M0,0v9.6C0,12,2,14,4.4,14h5.1C12,14,14,12,14,9.6V4.4C14,2,12,0,9.6,0H0z M9.2,12H4.8C3.3,12,2,10.7,2,9.2V2h7.2 C10.7,2,12,3.3,12,4.8v4.4C12,10.7,10.7,12,9.2,12z"/>',
        'rotate' => true,
    ),
    'flower_in' => array(
        'path' => '<path d="M14,14V4.4C14,2,12,0,9.6,0H4.4C2,0,0,2,0,4.4v5.1C0,12,2,14,4.4,14H14z M4.8,2h4.4C10.7,2,12,3.3,12,4.8V12H4.8 C3.3,12,2,10.7,2,9.2V4.8C2,3.3,3.3,2,4.8,2z"/>',
        'rotate' => true,
    ),
    'leaf' => array(
        'path' => '<path d="M0,0v9.6C0,12,2,14,4.4,14H14V4.4C14,2,12,0,9.6,0H0z M12,12H4.8C3.3,12,2,10.7,2,9.2V2h7.2C10.7,2,12,3.3,12,4.8V12z"/>',
        'rotate' => true,
    ),
    '3-corners' => array(
        'path' => '<path d="M14,0H4.4C2,0,0,2,0,4.4V14h14V0z M2,12V4.8C2,3.3,3.3,2,4.8,2H12v10H2z"/>',
        'rotate' => true,
    ),
    'vortex' => array(
        'path' => '<path d="M13.8,1.1c-3.5,3.9-3.8-1.9-12.8-0.9c3.9,3.5-1.9,3.8-0.9,12.8c3.5-3.9,3.8,1.9,12.8,0.9C9.1,10.4,14.9,10.1,13.8,1.1z
     M9.4,13.2c-6.5-1.6-5.2-5.6-8.6-3.8c1.6-6.5,5.6-5.2,3.8-8.6c6.5,1.6,5.2,5.6,8.6,3.8C11.7,11.1,7.6,9.8,9.4,13.2z"/><path d="M5.8,4.6"/>',
        'rotate' => false,
    ),
    'dots' => array(
        'path' => '<path d="M14,3.1c0-0.4-0.3-0.8-0.6-1c0.4-0.2,0.6-0.5,0.6-1C14,0.5,13.5,0,12.9,0c-0.4,0-0.8,0.3-1,0.6 c-0.2-0.4-0.5-0.6-1-0.6s-0.8,0.3-1,0.6C9.8,0.3,9.4,0,9,0C8.5,0,8.2,0.3,8,0.6C7.8,0.3,7.4,0,7,0S6.2,0.3,6,0.6C5.8,0.3,5.5,0,5,0 C4.6,0,4.2,0.3,4,0.6C3.9,0.3,3.5,0,3.1,0s-0.8,0.3-1,0.6C1.9,0.3,1.5,0,1.1,0C0.5,0,0,0.5,0,1.1c0,0.4,0.3,0.8,0.6,1 C0.3,2.2,0,2.6,0,3.1s0.3,0.8,0.6,1C0.3,4.2,0,4.6,0,5c0,0.4,0.3,0.8,0.6,1C0.3,6.2,0,6.6,0,7s0.3,0.8,0.6,1C0.3,8.2,0,8.5,0,9 c0,0.4,0.3,0.8,0.6,1c-0.4,0.2-0.6,0.5-0.6,1s0.3,0.8,0.6,1c-0.4,0.2-0.6,0.5-0.6,1C0,13.5,0.5,14,1.1,14c0.4,0,0.8-0.3,1-0.6 c0.2,0.4,0.5,0.6,1,0.6s0.8-0.3,1-0.6C4.2,13.7,4.6,14,5,14c0.4,0,0.8-0.3,1-0.6C6.2,13.7,6.6,14,7,14s0.8-0.3,1-0.6 C8.2,13.7,8.5,14,9,14c0.4,0,0.8-0.3,1-0.6c0.2,0.4,0.5,0.6,1,0.6s0.8-0.3,1-0.6c0.2,0.4,0.5,0.6,1,0.6c0.6,0,1.1-0.5,1.1-1.1 c0-0.4-0.3-0.8-0.6-1c0.4-0.2,0.6-0.5,0.6-1s-0.3-0.8-0.6-1C13.7,9.8,14,9.4,14,9c0-0.4-0.3-0.8-0.6-1C13.7,7.8,14,7.4,14,7 s-0.3-0.8-0.6-1C13.7,5.8,14,5.5,14,5c0-0.4-0.3-0.8-0.6-1C13.7,3.9,14,3.5,14,3.1z M11.9,12.5c-0.2-0.4-0.5-0.6-1-0.6 s-0.8,0.3-1,0.6c-0.2-0.4-0.5-0.6-1-0.6c-0.4,0-0.8,0.3-1,0.6c-0.2-0.4-0.5-0.6-1-0.6s-0.8,0.3-1,0.6c-0.2-0.4-0.5-0.6-1-0.6 c-0.4,0-0.8,0.3-1,0.6c-0.2-0.4-0.5-0.6-1-0.6s-0.8,0.3-1,0.6C2,12.2,1.8,12,1.5,11.9c0.4-0.2,0.6-0.5,0.6-1s-0.3-0.8-0.6-1 c0.4-0.2,0.6-0.5,0.6-1c0-0.4-0.3-0.8-0.6-1c0.4-0.2,0.6-0.5,0.6-1S1.9,6.2,1.5,6c0.4-0.2,0.6-0.5,0.6-1c0-0.4-0.3-0.8-0.6-1 c0.4-0.2,0.6-0.5,0.6-1s-0.3-0.8-0.6-1C1.8,2,2,1.8,2.1,1.5c0.2,0.4,0.5,0.6,1,0.6s0.8-0.3,1-0.6c0.2,0.4,0.5,0.6,1,0.6 c0.4,0,0.8-0.3,1-0.6c0.2,0.4,0.5,0.6,1,0.6s0.8-0.3,1-0.6c0.2,0.4,0.5,0.6,1,0.6c0.4,0,0.8-0.3,1-0.6c0.2,0.4,0.5,0.6,1,0.6 s0.8-0.3,1-0.6C12,1.8,12.2,2,12.5,2.1c-0.4,0.2-0.6,0.5-0.6,1s0.3,0.8,0.6,1c-0.4,0.2-0.6,0.5-0.6,1c0,0.4,0.3,0.8,0.6,1 c-0.4,0.2-0.6,0.5-0.6,1s0.3,0.8,0.6,1c-0.4,0.2-0.6,0.5-0.6,1c0,0.4,0.3,0.8,0.6,1c-0.4,0.2-0.6,0.5-0.6,1s0.3,0.8,0.6,1 C12.2,12,12,12.2,11.9,12.5z"/>',
        'rotate' => false,
    ),
    'bruised' => array(
        'path' => '<path d="M14,9.6V3c-1.7,0-3-1.3-3-3H4.4C2,0,0,2,0,4.4V11c1.7,0,3,1.3,3,3h6.6C12,14,14,12,14,9.6z M4.6,12C4.1,10.8,3.2,9.9,2,9.4 v-5C2,3.1,3.1,2,4.4,2h5c0.5,1.2,1.4,2.1,2.6,2.6v5c0,1.3-1.1,2.4-2.4,2.4H4.6z"/>',
        'rotate' => true,
    ),
    'canvas' => array(
        'path' => '<path class="st0" d="M13.8,1.8H14V0.2h-0.2V0h-1.6v0.2H12v0L11.7,0L11,0.4L10.3,0L9.7,0.4L9,0L8.3,0.4L7.7,0L7,0.4L6.3,0L5.7,0.4
    L5,0L4.3,0.4L3.7,0L3,0.4L2.3,0L2,0.2v0H1.8V0H0.2v0.2H0v1.6h0.2V2h0L0,2.3L0.4,3L0,3.7l0.4,0.7L0,5l0.4,0.7L0,6.3L0.4,7L0,7.7
    l0.4,0.7L0,9l0.4,0.7L0,10.3L0.4,11L0,11.7L0.2,12h0v0.2H0v1.6h0.2V14h1.6v-0.2H2v0L2.3,14L3,13.6L3.7,14l0.7-0.4L5,14l0.7-0.4
    L6.3,14L7,13.6L7.7,14l0.7-0.4L9,14l0.7-0.4l0.7,0.4l0.7-0.4l0.7,0.4l0.3-0.2v0h0.2V14h1.6v-0.2H14v-1.6h-0.2V12h0l0.2-0.3L13.6,11
    l0.4-0.7l-0.4-0.7L14,9l-0.4-0.7L14,7.7L13.6,7L14,6.3l-0.4-0.7L14,5l-0.4-0.7L14,3.7L13.6,3L14,2.3L13.8,2h0V1.8z M12.4,3L12,3.7
    l0.4,0.7L12,5l0.4,0.7L12,6.3L12.4,7L12,7.7l0.4,0.7L12,9l0.4,0.7L12,10.3l0.4,0.7L12,11.7l0.2,0.3h0v0.2H12v0L11.7,12L11,12.4
    L10.3,12l-0.7,0.4L9,12l-0.7,0.4L7.7,12L7,12.4L6.3,12l-0.7,0.4L5,12l-0.7,0.4L3.7,12L3,12.4L2.3,12L2,12.2v0H1.8V12h0L2,11.7
    L1.6,11L2,10.3L1.6,9.7L2,9L1.6,8.3L2,7.7L1.6,7L2,6.3L1.6,5.7L2,5L1.6,4.3L2,3.7L1.6,3L2,2.3L1.8,2h0V1.8H2v0L2.3,2L3,1.6L3.7,2
    l0.7-0.4L5,2l0.7-0.4L6.3,2L7,1.6L7.7,2l0.7-0.4L9,2l0.7-0.4L10.3,2L11,1.6L11.7,2L12,1.8v0h0.2V2h0L12,2.3L12.4,3z"/>',
        'rotate' => true,
    ),
);

$markersIn = array(
    'default' => array(
        'path' => '<rect width="6" height="6"/>',
        'rotate' => false,
        'preview' => '<path d="M5,1h1l0-1L4,0v1H3V0L0,0v0v0v2h1V1h0h1h1v1v0v0l0,0H2v1H1H0h0v3h0v0h2v0H1l0-2h1l0,1h1v1h3v0H5v0V5h1V4H5v1H3 l0-2l1,0v1h1V3h1V2H5V1z M5,3H4V2h1V3z"/>',
        'marker' => true,
    ),
    'flurry' => array(
        'path' => '<polygon points="5.9,5.9 5.6,5.9 5.3,6 5,5.7 4.7,5.8 4.4,5.8 4.1,5.8 3.9,5.7 3.6,5.7 3.3,5.8 3,5.9 2.7,5.8 2.4,5.8 2.1,5.8 1.9,5.7 1.6,5.7 1.3,5.7 1,5.8 0.7,5.8 0.4,5.8 0.1,5.9 0,5.5 0.1,5.3 0,5 0.3,4.7 0.3,4.4 0.2,4.1 0.2,3.8 0.1,3.5 0.3,3.3 0.1,3 0.1,2.7 0.2,2.4 0.1,2.1 0.1,1.8 0.1,1.5 0.2,1.3 0.3,1 0,0.7 0,0.4 0.3,0.2 0.4,0.1 0.7,0.1 1,0.2 1.3,0.1 1.6,0.3 1.9,0.1 2.1,0.1 2.4,0.2 2.7,0.1 3,0.3 3.3,0.2 3.6,0.2 3.8,0.2 4.1,0.1 4.4,0.3 4.7,0.1 5,0.2 5.3,0.1 5.6,0 5.9,0 5.8,0.4 6,0.7 6,1 5.9,1.2 5.7,1.5 5.7,1.8 5.9,2.1 5.7,2.4 5.8,2.7 6,3 5.9,3.3 5.8,3.5 5.8,3.8 5.8,4.1 6,4.4 5.8,4.7 5.7,5 5.7,5.3 5.8,5.5"/>',
        'rotate' => false,
        'marker' => true,
    ),
    'sdoz' => array(
        'path' => '<polygon points="6,6 0.5,6 0,0 6,0.5"/>',
        'rotate' => true,
        'marker' => true,
    ),
    'drop_in' => array(
        'path' => '<path d="M3,6L3,6C1.3,6,0,4.7,0,3l0-3l3,0c1.7,0,3,1.3,3,3v0C6,4.7,4.7,6,3,6z"/>',
        'rotate' => true,
        'marker' => true,
    ),
    'drop' => array(
        'path' => '<path d="M6,6H3C1.3,6,0,4.7,0,3v0c0-1.7,1.3-3,3-3h0c1.7,0,3,1.3,3,3V6z"/>',
        'rotate' => true,
        'marker' => true,
    ),
    'dropeye' => array(
        'path' => '<path d="M6,6H3C1.3,6,0,4.7,0,3l0-3l3,0c1.7,0,3,1.3,3,3V6z"/>',
        'rotate' => true,
        'marker' => true,
    ),
    'circle' => array(
        'path' => '<circle cx="3" cy="3" r="3"/>',
        'rotate' => false,
        'preview' => '<circle cx="0.5" cy="0.5" r="0.5"/>
        <circle cx="1.5" cy="0.5" r="0.5"/>
        <circle cx="3.5" cy="0.5" r="0.5"/>
        <circle cx="4.5" cy="0.5" r="0.5"/>
        <circle cx="0.5" cy="1.5" r="0.5"/>
        <circle cx="4.5" cy="1.5" r="0.5"/>
        <circle cx="5.5" cy="1.5" r="0.5"/>
        <circle cx="0.5" cy="2.5" r="0.5"/>
        <circle cx="1.5" cy="2.5" r="0.5"/>
        <circle cx="0.5" cy="3.5" r="0.5"/>
        <circle cx="1.5" cy="3.5" r="0.5"/>
        <circle cx="4.5" cy="3.5" r="0.5"/>
        <circle cx="5.5" cy="3.5" r="0.5"/>
        <circle cx="2.5" cy="4.5" r="0.5"/>
        <circle cx="1.5" cy="5.5" r="0.5"/>
        <circle cx="3.5" cy="5.5" r="0.5"/>
        <circle cx="5.5" cy="5.5" r="0.5"/>',
        'marker' => true,
    ),
    'dot' => array(
        'path' => '<circle cx="3" cy="3" r="2"/>',
        'rotate' => false,
        'preview' => '<circle cx="0.5" cy="0.5" r="0.3"/>
        <circle cx="1.5" cy="0.5" r="0.3"/>
        <circle cx="3.5" cy="0.5" r="0.3"/>
        <circle cx="4.5" cy="0.5" r="0.3"/>
        <circle cx="0.5" cy="1.5" r="0.3"/>
        <circle cx="4.5" cy="1.5" r="0.3"/>
        <circle cx="5.5" cy="1.5" r="0.3"/>
        <circle cx="0.5" cy="2.5" r="0.3"/>
        <circle cx="1.5" cy="2.5" r="0.3"/>
        <circle cx="0.5" cy="3.5" r="0.3"/>
        <circle cx="1.5" cy="3.5" r="0.3"/>
        <circle cx="4.5" cy="3.5" r="0.3"/>
        <circle cx="5.5" cy="3.5" r="0.3"/>
        <circle cx="2.5" cy="4.5" r="0.3"/>
        <circle cx="1.5" cy="5.5" r="0.3"/>
        <circle cx="3.5" cy="5.5" r="0.3"/>
        <circle cx="5.5" cy="5.5" r="0.3"/>',
        'marker' => false,
    ),
    'rounded' => array(
        'path' => '<path d="M6,1.7v2.7C6,5.2,5.2,6,4.3,6H1.7C0.7,6,0,5.3,0,4.3V1.7C0,0.8,0.8,0,1.7,0h2.7C5.3,0,6,0.7,6,1.7z"/>',
        'rotate' => false,
        'marker' => true,
    ),
    'sun' => array(
        'path' => '<polygon points="3,0 3.4,0.7 4,0.2 4.1,0.9 4.9,0.7 4.8,1.5 5.6,1.5 5.2,2.2 5.9,2.5 5.3,3 5.9,3.5 5.2,3.8 5.6,4.5 4.8,4.5 4.9,5.3 4.1,5.1 4,5.8 3.4,5.3 3,6 2.5,5.3 1.9,5.8 1.8,5.1 1,5.3 1.1,4.5 0.4,4.5 0.7,3.8 0,3.5 0.6,3 0,2.5 0.7,2.2 0.4,1.5 1.1,1.5 1,0.7 1.8,0.9 1.9,0.2 2.5,0.7"/>',
        'rotate' => false,
        'marker' => true,
    ),
    'star' => array(
        'path' => '<path d="M3.2,0.3l0.6,1.3C4,1.8,4.1,1.9,4.3,1.9l1.4,0.2c0.2,0,0.3,0.3,0.2,0.5l-1,1C4.7,3.7,4.7,3.9,4.7,4.1L5,5.5 c0,0.2-0.2,0.4-0.4,0.3L3.3,5.2c-0.2-0.1-0.4-0.1-0.6,0L1.4,5.8C1.2,5.9,1,5.8,1,5.5l0.2-1.4c0-0.2,0-0.4-0.2-0.5l-1-1 C-0.1,2.4,0,2.2,0.2,2.1l1.4-0.2c0.2,0,0.4-0.2,0.5-0.3l0.6-1.3C2.9,0.1,3.1,0.1,3.2,0.3z"/>',
        'rotate' => false,
        'preview' => '<polygon points="0.5,0.8 0.2,1 0.2,0.6 0,0.4 0.3,0.3 0.5,0 0.7,0.3 1,0.4 0.7,0.6 0.8,1"/>
<polygon points="2.5,0.8 2.2,1 2.2,0.6 2,0.4 2.3,0.3 2.5,0 2.7,0.3 3,0.4 2.7,0.6 2.8,1"/>
<polygon points="4.5,0.8 4.2,1 4.3,0.6 4,0.4 4.3,0.3 4.5,0 4.7,0.3 5,0.4 4.8,0.6 4.8,1"/>
<polygon points="5.5,0.8 5.2,1 5.3,0.6 5,0.4 5.3,0.3 5.5,0 5.7,0.3 6,0.4 5.8,0.6 5.8,1"/>
<polygon points="3.5,1.8 3.2,2 3.2,1.6 3,1.4 3.3,1.3 3.5,1 3.7,1.3 4,1.4 3.7,1.6 3.8,2"/>
<polygon points="4.5,1.8 4.2,2 4.2,1.6 4,1.4 4.3,1.3 4.5,1 4.7,1.3 5,1.4 4.7,1.6 4.8,2"/>
<polygon points="2.5,2.8 2.2,3 2.2,2.6 2,2.4 2.3,2.3 2.5,2 2.7,2.3 3,2.4 2.7,2.6 2.8,3"/>
<polygon points="3.5,2.8 3.2,3 3.2,2.6 3,2.4 3.3,2.3 3.5,2 3.7,2.3 4,2.4 3.7,2.6 3.8,3"/>
<polygon points="0.5,3.8 0.2,4 0.2,3.6 0,3.4 0.3,3.3 0.5,3 0.7,3.3 1,3.4 0.7,3.6 0.8,4"/>
<polygon points="1.5,3.8 1.2,4 1.2,3.6 1,3.4 1.3,3.3 1.5,3 1.7,3.3 2,3.4 1.7,3.6 1.8,4"/>
<polygon points="2.5,5.8 2.2,6 2.2,5.6 2,5.4 2.3,5.3 2.5,5 2.7,5.3 3,5.4 2.8,5.6 2.8,6"/>
<polygon points="3.5,5.8 3.2,6 3.2,5.6 3,5.4 3.3,5.3 3.5,5 3.7,5.3 4,5.4 3.8,5.6 3.8,6"/>
<polygon points="0.5,1.8 0.2,2 0.2,1.6 0,1.4 0.3,1.3 0.5,1 0.7,1.3 1,1.4 0.7,1.6 0.8,2"/>
<polygon points="4.5,3.8 4.2,4 4.3,3.6 4,3.4 4.3,3.3 4.5,3 4.7,3.3 5,3.4 4.8,3.6 4.8,4"/>
<polygon points="5.5,4.8 5.2,5 5.3,4.6 5,4.4 5.3,4.3 5.5,4 5.7,4.3 6,4.4 5.8,4.6 5.8,5"/>
<polygon points="0.5,5.8 0.2,6 0.2,5.6 0,5.4 0.3,5.3 0.5,5 0.7,5.3 1,5.4 0.7,5.6 0.8,6"/>',
    'marker' => true,
    ),
    'diamond' => array(
        'path' => '<rect x="0.9" y="0.9" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -1.2426 3)" width="4.2" height="4.2"/>',
        'rotate' => false,
        'preview' => '<rect x="0.1" y="0.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -0.2075 0.4992)" width="0.7" height="0.7"/>
<rect x="0.1" y="1.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -0.9146 0.7923)" width="0.7" height="0.7"/>
<rect x="2.1" y="0.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 0.3783 1.9134)" width="0.7" height="0.7"/>
<rect x="4.1" y="0.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 0.9641 3.3276)" width="0.7" height="0.7"/>
<rect x="5.1" y="0.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 1.257 4.0347)" width="0.7" height="0.7"/>
<rect x="4.1" y="1.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 0.257 3.6205)" width="0.7" height="0.7"/>
<rect x="3.1" y="1.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -3.593460e-02 2.9134)" width="0.7" height="0.7"/>
<rect x="3.1" y="2.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -0.743 3.2063)" width="0.7" height="0.7"/>
<rect x="2.1" y="2.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -1.0359 2.4992)" width="0.7" height="0.7"/>
<rect x="1.1" y="3.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -2.0359 2.0849)" width="0.7" height="0.7"/>
<rect x="0.1" y="3.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -2.3287 1.3777)" width="0.7" height="0.7"/>
<rect x="0.1" y="5.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -3.7428 1.9634)" width="0.7" height="0.7"/>
<rect x="2.1" y="5.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -3.1573 3.3778)" width="0.7" height="0.7"/>
<rect x="3.1" y="5.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -2.8644 4.0849)" width="0.7" height="0.7"/>
<rect x="5.1" y="4.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -1.5715 5.2063)" width="0.7" height="0.7"/>
<rect x="4.1" y="3.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -1.1573 4.2063)" width="0.7" height="0.7"/>',
        'marker' => true,
    ),
    'sparkle' => array(
        'path' => '<path d="M3,0L3,0c0,1.7-1.3,3-3,3h0h0c1.7,0,3,1.3,3,3v0v0c0-1.7,1.3-3,3-3h0h0C4.3,3,3,1.7,3,0L3,0z"/>',
        'rotate' => false,
        'preview' => '<path d="M0.4,0.9L0.4,0.9L0.4,0.9h0.1c0-0.2,0.2-0.3,0.4-0.4l0.1,0l0.1,0c0.2,0,0.3,0.2,0.4,0.4v0.1c0,0.2-0.2,0.3-0.4,0.4L1,1.5 v0.1l0.1,0c0.2,0,0.3,0.2,0.4,0.4v0.1c0,0.2-0.2,0.3-0.4,0.4L1,2.5v0.1l0.1,0c0.2,0,0.3,0.2,0.4,0.4l0,0.1h0.1l0-0.1 c0-0.2,0.2-0.3,0.4-0.4l0.1,0V2.5l-0.1,0c-0.2,0-0.3-0.2-0.4-0.4V1.9c0-0.2,0.2-0.3,0.4-0.4l0.1,0V1.5l-0.1,0 c-0.2,0-0.3-0.2-0.4-0.4V0.9c0-0.2,0.2-0.3,0.4-0.4l0.1,0V0.5l-0.1,0c-0.2,0-0.3-0.2-0.4-0.4l0-0.1H1.5l0,0.1 c0,0.2-0.2,0.3-0.4,0.4L1,0.5l-0.1,0c-0.2,0-0.3-0.2-0.4-0.4l0-0.1H0.5l0,0.1c0,0.2-0.2,0.3-0.4,0.4L0,0.5v0.1l0.1,0 C0.3,0.6,0.4,0.7,0.4,0.9z"/>
    <path d="M3.6,4.1L3.6,4.1L3.6,4.1H3.4c0,0.2-0.2,0.3-0.4,0.4H2.9c-0.2,0-0.3-0.2-0.4-0.4l0-0.1H2.5l0,0.1c0,0.2-0.2,0.3-0.4,0.4 L2,4.5v0.1l0.1,0c0.2,0,0.3,0.2,0.4,0.4v0.1c0,0.2-0.2,0.3-0.4,0.4H1.9c-0.2,0-0.3-0.2-0.4-0.4l0-0.1H1.5l0,0.1 c0,0.2-0.2,0.3-0.4,0.4H0.9c-0.2,0-0.3-0.2-0.4-0.4V4.9c0-0.2,0.2-0.3,0.4-0.4l0.1,0V4.5l-0.1,0c-0.2,0-0.3-0.2-0.4-0.4V3.9 c0-0.2,0.2-0.3,0.4-0.4l0.1,0V3.5l-0.1,0c-0.2,0-0.3-0.2-0.4-0.4l0-0.1H0.5l0,0.1c0,0.2-0.2,0.3-0.4,0.4L0,3.5v0.1l0.1,0 c0.2,0,0.3,0.2,0.4,0.4v0.1c0,0.2-0.2,0.3-0.4,0.4L0,4.5v0.1l0.1,0c0.2,0,0.3,0.2,0.4,0.4v0.1c0,0.2-0.2,0.3-0.4,0.4L0,5.5v0.1 l0.1,0c0.2,0,0.3,0.2,0.4,0.4l0,0.1h0.1l0-0.1c0-0.2,0.2-0.3,0.4-0.4h0.1c0.2,0,0.3,0.2,0.4,0.4l0,0.1h0.1l0-0.1 c0-0.2,0.2-0.3,0.4-0.4h0.1c0.2,0,0.3,0.2,0.4,0.4l0,0.1h0.1l0-0.1c0-0.2,0.2-0.3,0.4-0.4h0.1c0.2,0,0.3,0.2,0.4,0.4l0,0.1h0.1 l0-0.1c0-0.2,0.2-0.3,0.4-0.4l0.1,0V5.5l-0.1,0c-0.2,0-0.3-0.2-0.4-0.4V4.9c0-0.2,0.2-0.3,0.4-0.4l0.1,0V4.5l-0.1,0 C3.7,4.4,3.6,4.3,3.6,4.1z M3.4,5.1c0,0.2-0.2,0.3-0.4,0.4H2.9c-0.2,0-0.3-0.2-0.4-0.4V4.9c0-0.2,0.2-0.3,0.4-0.4h0.1 c0.2,0,0.3,0.2,0.4,0.4V5.1z"/>
    <path d="M5.6,4.1L5.6,4.1L5.6,4.1H5.4c0,0.2-0.2,0.3-0.4,0.4L5,4.5v0.1l0.1,0c0.2,0,0.3,0.2,0.4,0.4l0,0.1h0.1l0-0.1 c0-0.2,0.2-0.3,0.4-0.4l0.1,0V4.5l-0.1,0C5.7,4.4,5.6,4.3,5.6,4.1z"/>
    <path d="M5.6,2.1L5.6,2.1L5.6,2.1H5.4c0,0.2-0.2,0.3-0.4,0.4H4.9c-0.2,0-0.3-0.2-0.4-0.4l0-0.1H4.5l0,0.1c0,0.2-0.2,0.3-0.4,0.4 H3.9c-0.2,0-0.3-0.2-0.4-0.4V1.9c0-0.2,0.2-0.3,0.4-0.4l0.1,0V1.5l-0.1,0c-0.2,0-0.3-0.2-0.4-0.4V0.9c0-0.2,0.2-0.3,0.4-0.4l0.1,0 V0.5l-0.1,0c-0.2,0-0.3-0.2-0.4-0.4l0-0.1H3.5l0,0.1c0,0.2-0.2,0.3-0.4,0.4L3,0.5v0.1l0.1,0c0.2,0,0.3,0.2,0.4,0.4v0.1 c0,0.2-0.2,0.3-0.4,0.4L3,1.5v0.1l0.1,0c0.2,0,0.3,0.2,0.4,0.4v0.1c0,0.2-0.2,0.3-0.4,0.4L3,2.5v0.1l0.1,0c0.2,0,0.3,0.2,0.4,0.4 l0,0.1h0.1l0-0.1c0-0.2,0.2-0.3,0.4-0.4h0.1c0.2,0,0.3,0.2,0.4,0.4l0,0.1h0.1l0-0.1c0-0.2,0.2-0.3,0.4-0.4h0.1 c0.2,0,0.3,0.2,0.4,0.4l0,0.1h0.1l0-0.1c0-0.2,0.2-0.3,0.4-0.4l0.1,0V2.5l-0.1,0C5.7,2.4,5.6,2.3,5.6,2.1z"/>
    <path d="M5.9,0.4c-0.2,0-0.3-0.2-0.4-0.4l0-0.1H5.5l0,0.1c0,0.2-0.2,0.3-0.4,0.4L5,0.5v0.1l0.1,0c0.2,0,0.3,0.2,0.4,0.4l0,0.1h0.1 l0-0.1c0-0.2,0.2-0.3,0.4-0.4V0.4L5.9,0.4L5.9,0.4z"/>',
    ),
    'danger' => array(
        'path' => '<polygon points="3,5.1 3.9,6 6,6 6,3.9 5.1,3 6,2.1 6,0 3.9,0 3,0.9 2.1,0 0,0 0,2.1 0.9,3 0,3.9 0,6 2.1,6"/>',
        'rotate' => false,
        'preview' => '<polygon points="2.9,0.5 3,0.4 3,0 2.6,0 2.5,0.1 2.4,0 2,0 2,0.4 2.1,0.5 2,0.6 2,1 2.4,1 2.5,0.9 2.6,1 3,1 3,0.6"/>
    <path d="M6,0H5.6L5.5,0.1L5.4,0H5H4.6L4.5,0.1L4.4,0H4v0.4l0.1,0.1L4,0.6V1H3.6L3.5,1.1L3.4,1H3v0.4l0.1,0.1L3,1.6V2 h0.4l0.1-0.1L3.6,2H4h0.4l0.1-0.1L4.6,2H5V1.6L4.9,1.5L5,1.4V1h0.4l0.1-0.1L5.6,1H6V0.6L5.9,0.5L6,0.4V0z M4,1.6L3.9,1.5L4,1.4 l0.1,0.1L4,1.6z M4.5,1.1L4.4,1l0.1-0.1L4.6,1L4.5,1.1z M5,0.6L4.9,0.5L5,0.4l0.1,0.1L5,0.6z"/>
    <polygon points="2.5,2.1 2.4,2 2,2 2,2.4 2.1,2.5 2,2.6 2,3 2.4,3 2.5,2.9 2.6,3 3,3 3,2.6 2.9,2.5 3,2.4 3,2 2.6,2"/>
    <path d="M0.5,1.9L0.6,2H1V1.6L0.9,1.5L1,1.4V1V0.6L0.9,0.5L1,0.4V0H0.6L0.5,0.1L0.4,0H0v0.4l0.1,0.1L0,0.6V1v0.4 l0.1,0.1L0,1.6V2h0.4L0.5,1.9z M0.5,0.9L0.6,1L0.5,1.1L0.4,1L0.5,0.9z"/>
    <path d="M1.5,3.1L1.4,3H1H0.6L0.5,3.1L0.4,3H0v0.4l0.1,0.1L0,3.6V4h0.4l0.1-0.1L0.6,4H1h0.4l0.1-0.1L1.6,4H2V3.6 L1.9,3.5L2,3.4V3H1.6L1.5,3.1z M1,3.6L0.9,3.5L1,3.4l0.1,0.1L1,3.6z"/>
    <polygon points="0.5,5.1 0.4,5 0,5 0,5.4 0.1,5.5 0,5.6 0,6 0.4,6 0.5,5.9 0.6,6 1,6 1,5.6 0.9,5.5 1,5.4 1,5 0.6,5"/>
    <path d="M3.5,5.1L3.4,5H3H2.6L2.5,5.1L2.4,5H2v0.4l0.1,0.1L2,5.6V6h0.4l0.1-0.1L2.6,6H3h0.4l0.1-0.1L3.6,6H4V5.6 L3.9,5.5L4,5.4V5H3.6L3.5,5.1z M3,5.6L2.9,5.5L3,5.4l0.1,0.1L3,5.6z"/>
    <polygon points="4.9,3.5 5,3.4 5,3 4.6,3 4.5,3.1 4.4,3 4,3 4,3.4 4.1,3.5 4,3.6 4,4 4.4,4 4.5,3.9 4.6,4 5,4 5,3.6"/>
    <polygon points="5.5,4.1 5.4,4 5,4 5,4.4 5.1,4.5 5,4.6 5,5 5.4,5 5.5,4.9 5.6,5 6,5 6,4.6 5.9,4.5 6,4.4 6,4 5.6,4"/>',
        'marker' => true,
    ),
    'cross' => array(
        'path' => '<polygon points="6,1.5 4.5,1.5 4.5,0 1.5,0 1.5,1.5 0,1.5 0,4.5 1.5,4.5 1.5,6 4.5,6 4.5,4.5 6,4.5"/>',
        'rotate' => false,
        'preview' => '<polygon points="0.3,2 0.7,2 0.7,1.7 1,1.7 1,1.3 0.7,1.3 0.7,1 0.7,0.7 1,0.7 1,0.3 0.7,0.3 0.7,0 0.3,0 0.3,0.3 0,0.3 0,0.7 0.3,0.7 0.3,1 0.3,1.3 0,1.3 0,1.7 0.3,1.7 "/>
<polygon points="2.3,1 2.7,1 2.7,0.7 3,0.7 3,0.3 2.7,0.3 2.7,0 2.3,0 2.3,0.3 2,0.3 2,0.7 2.3,0.7 "/>
<polygon points="5.7,0.3 5.7,0 5.3,0 5.3,0.3 5,0.3 4.7,0.3 4.7,0 4.3,0 4.3,0.3 4,0.3 4,0.7 4.3,0.7 4.3,1 4.3,1.3 4,1.3 3.7,1.3 3.7,1 3.3,1 3.3,1.3 3,1.3 3,1.7 3.3,1.7 3.3,2 3.7,2 3.7,1.7 4,1.7 4,1.7 4.3,1.7 4.3,2 4.7,2 4.7,1.7 5,1.7 5,1.3 4.7,1.3 4.7,1 4.7,0.7 5,0.7 5,0.7 5.3,0.7 5.3,1 5.7,1 5.7,0.7 6,0.7 6,0.3 "/>
<polygon points="2.3,3 2.7,3 2.7,2.7 3,2.7 3,2.3 2.7,2.3 2.7,2 2.3,2 2.3,2.3 2,2.3 2,2.7 2.3,2.7 "/>
<polygon points="1.7,3 1.3,3 1.3,3.3 1,3.3 0.7,3.3 0.7,3 0.3,3 0.3,3.3 0,3.3 0,3.7 0.3,3.7 0.3,4 0.7,4 0.7,3.7 1,3.7 1,3.7 1.3,3.7 1.3,4 1.7,4 1.7,3.7 2,3.7 2,3.3 1.7,3.3 "/>
<polygon points="4.7,3 4.3,3 4.3,3.3 4,3.3 4,3.7 4.3,3.7 4.3,4 4.7,4 4.7,3.7 5,3.7 5,3.3 4.7,3.3 "/>
<polygon points="5.7,4 5.3,4 5.3,4.3 5,4.3 5,4.7 5.3,4.7 5.3,5 5.7,5 5.7,4.7 6,4.7 6,4.3 5.7,4.3 "/>
<polygon points="3.7,5 3.3,5 3.3,5.3 3,5.3 2.7,5.3 2.7,5 2.3,5 2.3,5.3 2,5.3 2,5.7 2.3,5.7 2.3,6 2.7,6 2.7,5.7 3,5.7 3,5.7 3.3,5.7 3.3,6 3.7,6 3.7,5.7 4,5.7 4,5.3 3.7,5.3 "/>
<polygon points="0.7,5 0.3,5 0.3,5.3 0,5.3 0,5.7 0.3,5.7 0.3,6 0.7,6 0.7,5.7 1,5.7 1,5.3 0.7,5.3 "/>',
        'marker' => true,
    ),
    'plus' => array(
        'path' => '<path d="M4.5,1.5L4.5,1.5L4.5,1.5C4.5,0.7,3.8,0,3,0h0C2.2,0,1.5,0.7,1.5,1.5v0h0C0.7,1.5,0,2.2,0,3v0 c0,0.8,0.7,1.5,1.5,1.5h0v0C1.5,5.3,2.2,6,3,6h0c0.8,0,1.5-0.7,1.5-1.5v0h0C5.3,4.5,6,3.8,6,3v0C6,2.2,5.3,1.5,4.5,1.5z"/>',
        'rotate' => false,
        'preview' => '<path d="M0.7,0.8L0.7,0.8L0.7,0.8c0.1-0.1,0.2-0.1,0.2-0.1C1,0.6,1,0.6,1,0.5c0-0.1-0.1-0.2-0.2-0.2H0.7V0.2
    C0.7,0.1,0.6,0,0.5,0S0.3,0.1,0.3,0.2v0.1H0.2C0.1,0.3,0,0.4,0,0.5s0.1,0.2,0.2,0.2h0.1v0.1C0.3,0.9,0.4,1,0.5,1 c0.1,0,0.1,0,0.2-0.1S0.7,0.8,0.7,0.8z"/>
<path d="M2.2,0.7L2.2,0.7L2.2,0.7C2.3,0.9,2.4,1,2.5,1c0.1,0,0.1,0,0.2-0.1s0.1-0.1,0.1-0.2V0.7h0.1 c0.1,0,0.1,0,0.2-0.1C3,0.6,3,0.6,3,0.5c0-0.1-0.1-0.2-0.2-0.2H2.7V0.2C2.7,0.1,2.6,0,2.5,0S2.3,0.1,2.3,0.2v0.1H2.2 C2.1,0.3,2,0.4,2,0.5S2.1,0.7,2.2,0.7z"/>
<path d="M4.7,0.8L4.7,0.8L4.7,0.8c0.1-0.1,0.2-0.1,0.2-0.1C5,0.6,5,0.6,5,0.5c0-0.1-0.1-0.2-0.2-0.2H4.7V0.2 C4.7,0.1,4.6,0,4.5,0S4.3,0.1,4.3,0.2v0.1H4.2C4.1,0.3,4,0.4,4,0.5s0.1,0.2,0.2,0.2h0.1v0.1C4.3,0.9,4.4,1,4.5,1 c0.1,0,0.1,0,0.2-0.1S4.7,0.8,4.7,0.8z"/>
<path d="M5.2,0.7L5.2,0.7L5.2,0.7C5.3,0.9,5.4,1,5.5,1c0.1,0,0.1,0,0.2-0.1s0.1-0.1,0.1-0.2V0.7h0.1 c0.1,0,0.1,0,0.2-0.1C6,0.6,6,0.6,6,0.5c0-0.1-0.1-0.2-0.2-0.2H5.7V0.2C5.7,0.1,5.6,0,5.5,0S5.3,0.1,5.3,0.2v0.1H5.2 C5.1,0.3,5,0.4,5,0.5S5.1,0.7,5.2,0.7z"/>
<path d="M4.2,1.7L4.2,1.7L4.2,1.7C4.3,1.9,4.4,2,4.5,2c0.1,0,0.1,0,0.2-0.1s0.1-0.1,0.1-0.2V1.7h0.1 c0.1,0,0.1,0,0.2-0.1C5,1.6,5,1.6,5,1.5c0-0.1-0.1-0.2-0.2-0.2H4.7V1.2C4.7,1.1,4.6,1,4.5,1S4.3,1.1,4.3,1.2v0.1H4.2 C4.1,1.3,4,1.4,4,1.5S4.1,1.7,4.2,1.7z"/>
<path d="M3.7,1.8L3.7,1.8L3.7,1.8c0.1-0.1,0.2-0.1,0.2-0.1C4,1.6,4,1.6,4,1.5c0-0.1-0.1-0.2-0.2-0.2H3.7V1.2 C3.7,1.1,3.6,1,3.5,1S3.3,1.1,3.3,1.2v0.1H3.2C3.1,1.3,3,1.4,3,1.5s0.1,0.2,0.2,0.2h0.1v0.1C3.3,1.9,3.4,2,3.5,2 c0.1,0,0.1,0,0.2-0.1S3.7,1.8,3.7,1.8z"/>
<path d="M3.2,2.7L3.2,2.7L3.2,2.7C3.3,2.9,3.4,3,3.5,3c0.1,0,0.1,0,0.2-0.1s0.1-0.1,0.1-0.2V2.7h0.1 c0.1,0,0.1,0,0.2-0.1C4,2.6,4,2.6,4,2.5c0-0.1-0.1-0.2-0.2-0.2H3.7V2.2C3.7,2.1,3.6,2,3.5,2S3.3,2.1,3.3,2.2v0.1H3.2 C3.1,2.3,3,2.4,3,2.5S3.1,2.7,3.2,2.7z"/>
<path d="M2.2,2.7L2.2,2.7L2.2,2.7C2.3,2.9,2.4,3,2.5,3c0.1,0,0.1,0,0.2-0.1s0.1-0.1,0.1-0.2V2.7h0.1 c0.1,0,0.1,0,0.2-0.1C3,2.6,3,2.6,3,2.5c0-0.1-0.1-0.2-0.2-0.2H2.7V2.2C2.7,2.1,2.6,2,2.5,2S2.3,2.1,2.3,2.2v0.1H2.2 C2.1,2.3,2,2.4,2,2.5S2.1,2.7,2.2,2.7z"/>
<path d="M0.3,1.2L0.3,1.2L0.3,1.2C0.1,1.3,0,1.4,0,1.5s0.1,0.2,0.2,0.2h0.1v0.1C0.3,1.9,0.4,2,0.5,2 c0.1,0,0.1,0,0.2-0.1s0.1-0.1,0.1-0.2V1.7h0.1c0.1,0,0.1,0,0.2-0.1C1,1.6,1,1.6,1,1.5c0-0.1-0.1-0.2-0.2-0.2H0.7V1.2 C0.7,1.1,0.6,1,0.5,1S0.3,1.1,0.3,1.2z"/>
<path d="M0.8,3.3L0.8,3.3L0.8,3.3C0.7,3.1,0.6,3,0.5,3S0.3,3.1,0.3,3.2v0.1H0.2C0.1,3.3,0,3.4,0,3.5s0.1,0.2,0.2,0.2 h0.1v0.1C0.3,3.9,0.4,4,0.5,4c0.1,0,0.1,0,0.2-0.1s0.1-0.1,0.1-0.2V3.7h0.1c0.1,0,0.1,0,0.2-0.1C1,3.6,1,3.6,1,3.5 C1,3.4,0.9,3.3,0.8,3.3z"/>
<path d="M1.8,3.3L1.8,3.3L1.8,3.3C1.7,3.1,1.6,3,1.5,3S1.3,3.1,1.3,3.2v0.1H1.2C1.1,3.3,1,3.4,1,3.5s0.1,0.2,0.2,0.2 h0.1v0.1C1.3,3.9,1.4,4,1.5,4c0.1,0,0.1,0,0.2-0.1s0.1-0.1,0.1-0.2V3.7h0.1c0.1,0,0.1,0,0.2-0.1C2,3.6,2,3.6,2,3.5 C2,3.4,1.9,3.3,1.8,3.3z"/>
<path d="M4.8,3.3L4.8,3.3L4.8,3.3C4.7,3.1,4.6,3,4.5,3S4.3,3.1,4.3,3.2v0.1H4.2C4.1,3.3,4,3.4,4,3.5s0.1,0.2,0.2,0.2 h0.1v0.1C4.3,3.9,4.4,4,4.5,4c0.1,0,0.1,0,0.2-0.1s0.1-0.1,0.1-0.2V3.7h0.1c0.1,0,0.1,0,0.2-0.1C5,3.6,5,3.6,5,3.5 C5,3.4,4.9,3.3,4.8,3.3z"/>
<path d="M5.8,4.3L5.8,4.3L5.8,4.3C5.7,4.1,5.6,4,5.5,4S5.3,4.1,5.3,4.2v0.1H5.2C5.1,4.3,5,4.4,5,4.5s0.1,0.2,0.2,0.2 h0.1v0.1C5.3,4.9,5.4,5,5.5,5c0.1,0,0.1,0,0.2-0.1s0.1-0.1,0.1-0.2V4.7h0.1c0.1,0,0.1,0,0.2-0.1C6,4.6,6,4.6,6,4.5 C6,4.4,5.9,4.3,5.8,4.3z"/>
<path d="M3.8,5.3L3.8,5.3L3.8,5.3C3.7,5.1,3.6,5,3.5,5S3.3,5.1,3.3,5.2v0.1H3.2C3.1,5.3,3,5.4,3,5.5s0.1,0.2,0.2,0.2 h0.1v0.1C3.3,5.9,3.4,6,3.5,6c0.1,0,0.1,0,0.2-0.1s0.1-0.1,0.1-0.2V5.7h0.1c0.1,0,0.1,0,0.2-0.1C4,5.6,4,5.6,4,5.5 C4,5.4,3.9,5.3,3.8,5.3z"/>
<path d="M2.8,5.3L2.8,5.3L2.8,5.3C2.7,5.1,2.6,5,2.5,5S2.3,5.1,2.3,5.2v0.1H2.2C2.1,5.3,2,5.4,2,5.5s0.1,0.2,0.2,0.2 h0.1v0.1C2.3,5.9,2.4,6,2.5,6c0.1,0,0.1,0,0.2-0.1s0.1-0.1,0.1-0.2V5.7h0.1c0.1,0,0.1,0,0.2-0.1C3,5.6,3,5.6,3,5.5 C3,5.4,2.9,5.3,2.8,5.3z"/>
<path d="M0.8,5.3L0.8,5.3L0.8,5.3C0.7,5.1,0.6,5,0.5,5S0.3,5.1,0.3,5.2v0.1H0.2C0.1,5.3,0,5.4,0,5.5s0.1,0.2,0.2,0.2 h0.1v0.1C0.3,5.9,0.4,6,0.5,6c0.1,0,0.1,0,0.2-0.1s0.1-0.1,0.1-0.2V5.7h0.1c0.1,0,0.1,0,0.2-0.1C1,5.6,1,5.6,1,5.5 C1,5.4,0.9,5.3,0.8,5.3z"/>',
        'marker' => true,
    ),
    'x' => array(
        'path' => '<path d="M3,5.1l0.4,0.4C3.7,5.8,4.1,6,4.5,6h0C5.3,6,6,5.3,6,4.5v0c0-0.4-0.2-0.8-0.4-1.1L5.1,3l0.4-0.4 C5.8,2.3,6,1.9,6,1.5v0C6,0.7,5.3,0,4.5,0h0C4.1,0,3.7,0.2,3.4,0.4L3,0.9L2.6,0.4C2.3,0.2,1.9,0,1.5,0h0C0.7,0,0,0.7,0,1.5v0 c0,0.4,0.2,0.8,0.4,1.1L0.9,3L0.4,3.4C0.2,3.7,0,4.1,0,4.5v0C0,5.3,0.7,6,1.5,6h0c0.4,0,0.8-0.2,1.1-0.4L3,5.1z"/>',
        'rotate' => false,
        'preview' => '<path d="M0.5,0.9L0.5,0.9C0.6,1,0.7,1,0.7,1s0.1,0,0.2-0.1C1,0.8,1,0.7,0.9,0.6L0.9,0.5l0.1-0.1C1,0.3,1,0.2,0.9,0.1 S0.7,0,0.6,0.1L0.5,0.1L0.4,0.1C0.3,0,0.2,0,0.1,0.1C0,0.2,0,0.3,0.1,0.4l0.1,0.1L0.1,0.6C0,0.7,0,0.8,0.1,0.9C0.1,1,0.2,1,0.3,1 C0.3,1,0.4,1,0.5,0.9L0.5,0.9z"/>
<path d="M2.1,0.9C2.1,1,2.2,1,2.3,1c0.1,0,0.1,0,0.2-0.1l0.1-0.1l0.1,0.1C2.6,1,2.7,1,2.7,1s0.1,0,0.2-0.1 C3,0.8,3,0.7,2.9,0.6L2.9,0.5l0.1-0.1C3,0.3,3,0.2,2.9,0.1S2.7,0,2.6,0.1L2.5,0.1L2.4,0.1C2.3,0,2.2,0,2.1,0.1S2,0.3,2.1,0.4 l0.1,0.1L2.1,0.6C2,0.7,2,0.8,2.1,0.9z"/>
<path d="M4.9,0.5L4.9,0.5C5,0.4,5,0.3,5,0.3s0-0.1-0.1-0.2C4.8,0,4.7,0,4.6,0.1L4.5,0.1L4.4,0.1C4.3,0,4.2,0,4.1,0.1 S4,0.3,4.1,0.4l0.1,0.1L4.1,0.6C4,0.7,4,0.8,4.1,0.9C4.1,1,4.2,1,4.3,1c0.1,0,0.1,0,0.2-0.1l0.1-0.1l0.1,0.1C4.6,1,4.7,1,4.7,1 s0.1,0,0.2-0.1C5,0.9,5,0.8,5,0.7C5,0.7,5,0.6,4.9,0.5L4.9,0.5z"/>
<path d="M5.9,0.5L5.9,0.5C6,0.3,6,0.2,5.9,0.1S5.7,0,5.6,0.1L5.5,0.1L5.4,0.1C5.3,0,5.2,0,5.1,0.1C5,0.1,5,0.2,5,0.3 s0,0.1,0.1,0.2l0.1,0.1L5.1,0.6C5,0.6,5,0.7,5,0.7c0,0.1,0,0.1,0.1,0.2C5.1,1,5.2,1,5.3,1c0.1,0,0.1,0,0.2-0.1l0.1-0.1l0.1,0.1 C5.6,1,5.7,1,5.7,1s0.1,0,0.2-0.1C6,0.8,6,0.7,5.9,0.5L5.9,0.5z"/>
<path d="M4.5,1.1L4.5,1.1C4.4,1,4.3,1,4.3,1S4.1,1,4.1,1.1C4,1.1,4,1.2,4,1.3s0,0.1,0.1,0.2l0.1,0.1L4.1,1.6 C4,1.6,4,1.7,4,1.7c0,0.1,0,0.1,0.1,0.2C4.1,2,4.2,2,4.3,2c0.1,0,0.1,0,0.2-0.1l0.1-0.1l0.1,0.1C4.6,2,4.7,2,4.7,2s0.1,0,0.2-0.1 C5,1.8,5,1.7,4.9,1.6L4.9,1.5l0.1-0.1C5,1.3,5,1.2,4.9,1.1C4.9,1,4.8,1,4.7,1C4.7,1,4.6,1,4.5,1.1L4.5,1.1z"/>
<path d="M3.9,1.5L3.9,1.5C4,1.4,4,1.3,4,1.3s0-0.1-0.1-0.2C3.8,1,3.7,1,3.6,1.1L3.5,1.1L3.4,1.1C3.3,1,3.2,1,3.1,1.1 C3,1.2,3,1.3,3.1,1.4l0.1,0.1L3.1,1.6C3,1.7,3,1.8,3.1,1.9C3.1,2,3.2,2,3.3,2c0.1,0,0.1,0,0.2-0.1l0.1-0.1l0.1,0.1 C3.6,2,3.7,2,3.7,2s0.1,0,0.2-0.1C4,1.9,4,1.8,4,1.7C4,1.7,4,1.6,3.9,1.5L3.9,1.5z"/>
<path d="M2.1,2.9C2.1,3,2.2,3,2.3,3c0.1,0,0.1,0,0.2-0.1l0.1-0.1l0.1,0.1C2.6,3,2.7,3,2.7,3s0.1,0,0.2-0.1 C3,2.8,3,2.7,2.9,2.6L2.9,2.5l0.1-0.1C3,2.3,3,2.2,2.9,2.1C2.8,2,2.7,2,2.6,2.1L2.5,2.1L2.4,2.1C2.3,2,2.2,2,2.1,2.1 C2,2.2,2,2.3,2.1,2.4l0.1,0.1L2.1,2.6C2,2.7,2,2.8,2.1,2.9z"/>
<path d="M0.1,1.9C0.1,2,0.2,2,0.3,2c0.1,0,0.1,0,0.2-0.1l0.1-0.1l0.1,0.1C0.6,2,0.7,2,0.7,2s0.1,0,0.2-0.1 C1,1.8,1,1.7,0.9,1.6L0.9,1.5l0.1-0.1C1,1.3,1,1.2,0.9,1.1C0.9,1,0.8,1,0.7,1C0.7,1,0.6,1,0.6,1.1L0.5,1.1L0.4,1.1 C0.4,1,0.3,1,0.3,1S0.1,1,0.1,1.1C0,1.2,0,1.3,0.1,1.4l0.1,0.1L0.1,1.6C0,1.7,0,1.8,0.1,1.9z"/>
<path d="M0.9,3.5L0.9,3.5C1,3.4,1,3.3,1,3.3s0-0.1-0.1-0.2C0.8,3,0.7,3,0.6,3.1L0.5,3.1L0.4,3.1C0.3,3,0.2,3,0.1,3.1 C0,3.2,0,3.3,0.1,3.4l0.1,0.1L0.1,3.6C0,3.7,0,3.8,0.1,3.9C0.1,4,0.2,4,0.3,4c0.1,0,0.1,0,0.2-0.1l0.1-0.1l0.1,0.1 C0.6,4,0.7,4,0.7,4s0.1,0,0.2-0.1C1,3.9,1,3.8,1,3.7C1,3.7,1,3.6,0.9,3.5L0.9,3.5z"/>
<path d="M1.9,3.6L1.9,3.6V3.4C2,3.3,2,3.2,1.9,3.1C1.8,3,1.7,3,1.6,3.1L1.5,3.1L1.4,3.1C1.3,3,1.2,3,1.1,3.1 C1,3.1,1,3.2,1,3.3s0,0.1,0.1,0.2l0.1,0.1L1.1,3.6C1,3.6,1,3.7,1,3.7c0,0.1,0,0.1,0.1,0.2C1.1,4,1.2,4,1.3,4c0.1,0,0.1,0,0.2-0.1 l0.1-0.1l0.1,0.1C1.6,4,1.7,4,1.7,4s0.1,0,0.2-0.1C2,3.8,2,3.7,1.9,3.6z"/>
<path d="M4.9,3.6L4.9,3.6V3.4C5,3.3,5,3.2,4.9,3.1C4.8,3,4.7,3,4.6,3.1L4.5,3.1L4.4,3.1C4.3,3,4.2,3,4.1,3.1 C4,3.2,4,3.3,4.1,3.4l0.1,0.1L4.1,3.6C4,3.7,4,3.8,4.1,3.9C4.1,4,4.2,4,4.3,4c0.1,0,0.1,0,0.2-0.1l0.1-0.1l0.1,0.1 C4.6,4,4.7,4,4.7,4s0.1,0,0.2-0.1C5,3.8,5,3.7,4.9,3.6z"/>
<path d="M5.9,4.1C5.8,4,5.7,4,5.6,4.1L5.5,4.1L5.4,4.1C5.3,4,5.2,4,5.1,4.1C5,4.2,5,4.3,5.1,4.4l0.1,0.1L5.1,4.6 C5,4.7,5,4.8,5.1,4.9C5.1,5,5.2,5,5.3,5c0.1,0,0.1,0,0.2-0.1l0.1-0.1l0.1,0.1C5.6,5,5.7,5,5.7,5s0.1,0,0.2-0.1C6,4.8,6,4.7,5.9,4.6 L5.9,4.5l0.1-0.1C6,4.3,6,4.2,5.9,4.1z"/>
<path d="M3.9,5.1C3.8,5,3.7,5,3.6,5.1L3.5,5.1L3.4,5.1C3.3,5,3.2,5,3.1,5.1C3,5.1,3,5.2,3,5.3s0,0.1,0.1,0.2l0.1,0.1 L3.1,5.6C3,5.6,3,5.7,3,5.7c0,0.1,0,0.1,0.1,0.2C3.1,6,3.2,6,3.3,6c0.1,0,0.1,0,0.2-0.1l0.1-0.1l0.1,0.1C3.6,6,3.7,6,3.7,6 s0.1,0,0.2-0.1C4,5.8,4,5.7,3.9,5.6L3.9,5.5l0.1-0.1C4,5.3,4,5.2,3.9,5.1z"/>
<path d="M2.9,5.5L2.9,5.5C3,5.4,3,5.3,3,5.3s0-0.1-0.1-0.2C2.8,5,2.7,5,2.6,5.1L2.5,5.1L2.4,5.1C2.3,5,2.2,5,2.1,5.1 C2,5.2,2,5.3,2.1,5.4l0.1,0.1L2.1,5.6C2,5.7,2,5.8,2.1,5.9C2.1,6,2.2,6,2.3,6c0.1,0,0.1,0,0.2-0.1l0.1-0.1l0.1,0.1 C2.6,6,2.7,6,2.7,6s0.1,0,0.2-0.1C3,5.9,3,5.8,3,5.7C3,5.7,3,5.6,2.9,5.5L2.9,5.5z"/>
<path d="M0.9,5.1C0.8,5,0.7,5,0.6,5.1L0.5,5.1L0.4,5.1C0.3,5,0.2,5,0.1,5.1C0,5.2,0,5.3,0.1,5.4l0.1,0.1L0.1,5.6 C0,5.7,0,5.8,0.1,5.9C0.1,6,0.2,6,0.3,6c0.1,0,0.1,0,0.2-0.1l0.1-0.1l0.1,0.1C0.6,6,0.7,6,0.7,6s0.1,0,0.2-0.1C1,5.8,1,5.7,0.9,5.6 L0.9,5.5l0.1-0.1C1,5.3,1,5.2,0.9,5.1z"/>',
        'marker' => true,
    ),
    'heart' => array(
        'path' => '<path d="M6,1.8C5.9,1,5.3,0.4,4.5,0.3C3.9,0.2,3.4,0.5,3,0.9C2.6,0.5,2.1,0.3,1.6,0.3C0.8,0.4,0.1,1,0,1.8 C0,2.3,0.1,2.7,0.3,3l0,0l0,0c0.1,0.1,0.2,0.2,0.3,0.3l1.9,2.2c0.3,0.3,0.7,0.3,0.9,0l1.8-1.9c0.1-0.1,0.3-0.3,0.4-0.5 C5.9,2.8,6.1,2.3,6,1.8z"/>',
        'rotate' => false,
        'preview' => '<path d="M0.8,0C0.7,0,0.6,0,0.5,0.1C0.4,0,0.4,0,0.3,0C0.1,0,0,0.1,0,0.3c0,0.1,0,0.1,0,0.2l0,0L0.5,1l0.4-0.5 C1,0.4,1,0.3,1,0.3C1,0.1,0.9,0,0.8,0z"/>
<path d="M2.8,0C2.7,0,2.6,0,2.5,0.1C2.4,0,2.4,0,2.3,0C2.1,0,2,0.1,2,0.3c0,0.1,0,0.1,0,0.2l0,0L2.5,1l0.4-0.5 C3,0.4,3,0.3,3,0.3C3,0.1,2.9,0,2.8,0z"/>
<path d="M4.8,0C4.7,0,4.6,0,4.5,0.1C4.4,0,4.4,0,4.3,0C4.1,0,4,0.1,4,0.3c0,0.1,0,0.1,0,0.2l0,0L4.5,1l0.4-0.5 C5,0.4,5,0.3,5,0.3C5,0.1,4.9,0,4.8,0z"/>
<path d="M5,0.5L5.5,1l0.4-0.5C6,0.4,6,0.3,6,0.3C6,0.1,5.9,0,5.8,0C5.7,0,5.6,0,5.5,0.1C5.4,0,5.4,0,5.3,0 C5.1,0,5,0.1,5,0.3C5,0.3,5,0.4,5,0.5L5,0.5z"/>
<path d="M4.8,1C4.7,1,4.6,1,4.5,1.1C4.4,1,4.4,1,4.3,1C4.1,1,4,1.1,4,1.3c0,0.1,0,0.1,0,0.2l0,0L4.5,2l0.4-0.5 C5,1.4,5,1.3,5,1.3C5,1.1,4.9,1,4.8,1z"/>
<path d="M3.8,1C3.7,1,3.6,1,3.5,1.1C3.4,1,3.4,1,3.3,1C3.1,1,3,1.1,3,1.3c0,0.1,0,0.1,0,0.2l0,0L3.5,2l0.4-0.5 C4,1.4,4,1.3,4,1.3C4,1.1,3.9,1,3.8,1z"/>
<path d="M2.8,2C2.7,2,2.6,2,2.5,2.1C2.4,2,2.4,2,2.3,2C2.1,2,2,2.1,2,2.3c0,0.1,0,0.1,0,0.2l0,0L2.5,3l0.4-0.5 C3,2.4,3,2.3,3,2.3C3,2.1,2.9,2,2.8,2z"/>
<path d="M0.8,1C0.7,1,0.6,1,0.5,1.1C0.4,1,0.4,1,0.3,1C0.1,1,0,1.1,0,1.3c0,0.1,0,0.1,0,0.2l0,0L0.5,2l0.4-0.5 C1,1.4,1,1.3,1,1.3C1,1.1,0.9,1,0.8,1z"/>
<path d="M0.8,3C0.7,3,0.6,3,0.5,3.1C0.4,3,0.4,3,0.3,3C0.1,3,0,3.1,0,3.3c0,0.1,0,0.1,0,0.2l0,0L0.5,4l0.4-0.5 C1,3.4,1,3.3,1,3.3C1,3.1,0.9,3,0.8,3z"/>
<path d="M1.8,3C1.7,3,1.6,3,1.5,3.1C1.4,3,1.4,3,1.3,3C1.1,3,1,3.1,1,3.3c0,0.1,0,0.1,0,0.2l0,0L1.5,4l0.4-0.5 C2,3.4,2,3.3,2,3.3C2,3.1,1.9,3,1.8,3z"/>
<path d="M4.8,3C4.7,3,4.6,3,4.5,3.1C4.4,3,4.4,3,4.3,3C4.1,3,4,3.1,4,3.3c0,0.1,0,0.1,0,0.2l0,0L4.5,4l0.4-0.5 C5,3.4,5,3.3,5,3.3C5,3.1,4.9,3,4.8,3z"/>
<path d="M5.8,4C5.7,4,5.6,4,5.5,4.1C5.4,4,5.4,4,5.3,4C5.1,4,5,4.1,5,4.3c0,0.1,0,0.1,0,0.2l0,0L5.5,5l0.4-0.5 C6,4.4,6,4.3,6,4.3C6,4.1,5.9,4,5.8,4z"/>
<path d="M3.8,5C3.7,5,3.6,5,3.5,5.1C3.4,5,3.4,5,3.3,5C3.1,5,3,5.1,3,5.3c0,0.1,0,0.1,0,0.2l0,0L3.5,6l0.4-0.5 C4,5.4,4,5.3,4,5.3C4,5.1,3.9,5,3.8,5z"/>
<path d="M2.8,5C2.7,5,2.6,5,2.5,5.1C2.4,5,2.4,5,2.3,5C2.1,5,2,5.1,2,5.3c0,0.1,0,0.1,0,0.2l0,0L2.5,6l0.4-0.5 C3,5.4,3,5.3,3,5.3C3,5.1,2.9,5,2.8,5z"/>
<path d="M0.8,5C0.7,5,0.6,5,0.5,5.1C0.4,5,0.4,5,0.3,5C0.1,5,0,5.1,0,5.3c0,0.1,0,0.1,0,0.2l0,0L0.5,6l0.4-0.5 C1,5.4,1,5.3,1,5.3C1,5.1,0.9,5,0.8,5z"/>',
        'marker' => true,
    ),
    'shake' => array(
        'path' => '<rect x="0.5" y="0.5" width="5" height="5"/>',
        'rotate' => false,
        'preview' => '<rect x="0.1" y="0.1" transform="matrix(0.9962 -8.720575e-02 8.720575e-02 0.9962 -4.170330e-02 4.550928e-02)" width="0.8" height="0.8"/>
<rect x="2.1" y="0.1" transform="matrix(6.981014e-02 -0.9976 0.9976 6.981014e-02 1.8266 2.9591)" width="0.8" height="0.8"/>
<rect x="4.1" y="0.1" transform="matrix(0.1045 -0.9945 0.9945 0.1045 3.5323 4.9232)" width="0.8" height="0.8"/>
<rect x="5.1" y="0.1" transform="matrix(0.9962 -8.713004e-02 8.713004e-02 0.9962 -2.265348e-02 0.4811)" width="0.8" height="0.8"/>
<rect x="4.1" y="1.1" transform="matrix(0.9986 -5.233859e-02 5.233859e-02 0.9986 -7.234332e-02 0.2376)" width="0.8" height="0.8"/>
<rect x="3.1" y="1.1" transform="matrix(0.1736 -0.9848 0.9848 0.1736 1.415 4.6864)" width="0.8" height="0.8"/>
<rect x="2.1" y="2.1" transform="matrix(0.9962 -8.720575e-02 8.720575e-02 0.9962 -0.2085 0.2275)" width="0.8" height="0.8"/>
<rect x="0.1" y="1.1" transform="matrix(5.233460e-02 -0.9986 0.9986 5.233460e-02 -1.0241 1.9209)" width="0.8" height="0.8"/>
<rect x="0.1" y="3.1" transform="matrix(0.9998 -1.747158e-02 1.747158e-02 0.9998 -6.107527e-02 9.270038e-03)" width="0.8" height="0.8"/>
<rect x="1.1" y="3.1" transform="matrix(3.486695e-02 -0.9994 0.9994 3.486695e-02 -2.0502 4.8771)" width="0.8" height="0.8"/>
<rect x="4.1" y="3.1" transform="matrix(0.1564 -0.9877 0.9877 0.1564 0.3392 7.3973)" width="0.8" height="0.8"/>
<rect x="5.1" y="4.1" transform="matrix(0.1045 -0.9945 0.9945 0.1045 0.4498 9.4996)" width="0.8" height="0.8"/>
<rect x="3.1" y="5.1" transform="matrix(0.9962 -8.720575e-02 8.720575e-02 0.9962 -0.4663 0.3262)" width="0.8" height="0.8"/>
<rect x="2.1" y="5.1" transform="matrix(8.719913e-02 -0.9962 0.9962 8.719913e-02 -3.1971 7.511)" width="0.8" height="0.8"/>
<rect x="0.1" y="5.1" transform="matrix(8.719913e-02 -0.9962 0.9962 8.719913e-02 -5.0227 5.5186)" width="0.8" height="0.8"/>',
    ),
    'blob' => array(
        'path' => '<circle cx="3" cy="3" r="3"/>',
        'tb' => '<path d="M4.3,5.7C5.3,5.2,6,4.2,6,3S5.3,0.8,4.3,0.3C4.1,0.2,4,0.1,4,0H2c0,0.1-0.1,0.2-0.3,0.3C0.7,0.8,0,1.8,0,3 s0.7,2.2,1.7,2.7C1.9,5.8,2,5.9,2,6h2C4,5.9,4.1,5.8,4.3,5.7z"/>',
        'rl' => '<path d="M0.3,4.3C0.8,5.3,1.8,6,3,6s2.2-0.7,2.7-1.7C5.8,4.1,5.9,4,6,4V2C5.9,2,5.8,1.9,5.7,1.7C5.2,0.7,4.2,0,3,0 S0.8,0.7,0.3,1.7C0.2,1.9,0.1,2,0,2v2C0.1,4,0.2,4.1,0.3,4.3z"/>',
        'trbl' => '<path d="M4,0H2c0,1.1-0.9,2-2,2v2c1.1,0,2,0.9,2,2h2c0-1.1,0.9-2,2-2V2C4.9,2,4,1.1,4,0z"/>',
        'trl' => '<path d="M4.6,1.4C4.6,1.4,4.6,1.4,4.6,1.4C4.3,1.1,4.1,0.8,4,0.4C4,0.3,4,0.1,4,0H2c0,0.1,0,0.3,0,0.4 c-0.1,0.4-0.3,0.7-0.5,1c0,0,0,0,0,0C1,1.8,0.5,2,0,2v2c0.5,0,1,0.2,1.3,0.5c0,0,0,0,0,0C1.8,5,2.3,5.2,3,5.2S4.2,5,4.6,4.5 c0,0,0,0,0,0C5,4.2,5.5,4,6,4V2C5.5,2,5,1.8,4.6,1.4z"/>',
        'trb' => '<path d="M4.6,4.6C4.6,4.6,4.6,4.6,4.6,4.6c0.3-0.3,0.6-0.5,1-0.6C5.7,4,5.9,4,6,4V2C5.9,2,5.7,2,5.6,2 c-0.4-0.1-0.7-0.3-1-0.5c0,0,0,0,0,0C4.2,1,4,0.5,4,0H2c0,0.5-0.2,1-0.5,1.3c0,0,0,0,0,0C1,1.8,0.8,2.3,0.8,3S1,4.2,1.5,4.6 c0,0,0,0,0,0C1.8,5,2,5.5,2,6h2C4,5.5,4.2,5,4.6,4.6z"/>',
        'rbl' => '<path d="M1.4,4.6C1.4,4.6,1.4,4.6,1.4,4.6c0.3,0.3,0.5,0.6,0.6,1C2,5.7,2,5.9,2,6h2c0-0.1,0-0.3,0-0.4 c0.1-0.4,0.3-0.7,0.5-1c0,0,0,0,0,0C5,4.2,5.5,4,6,4V2C5.5,2,5,1.8,4.7,1.5c0,0,0,0,0,0C4.2,1,3.7,0.8,3,0.8S1.8,1,1.4,1.5 c0,0,0,0,0,0C1,1.8,0.5,2,0,2v2C0.5,4,1,4.2,1.4,4.6z"/>',
        'tbl' => '<path d="M1.4,1.4C1.4,1.4,1.4,1.4,1.4,1.4C1.1,1.7,0.8,1.9,0.4,2C0.3,2,0.1,2,0,2v2c0.1,0,0.3,0,0.4,0 c0.4,0.1,0.7,0.3,1,0.5c0,0,0,0,0,0C1.8,5,2,5.5,2,6h2c0-0.5,0.2-1,0.5-1.3c0,0,0,0,0,0C5,4.2,5.2,3.7,5.2,3S5,1.8,4.5,1.4 c0,0,0,0,0,0C4.2,1,4,0.5,4,0H2C2,0.5,1.8,1,1.4,1.4z"/>',
        'tr' => '<path d="M4.6,1.4C4.6,1.4,4.6,1.4,4.6,1.4C4.2,1,4,0.5,4,0H2c0,0.5-0.2,1-0.5,1.3l0,0C1,1.8,0.8,2.3,0.8,3 c0,1.2,1,2.2,2.2,2.2c0.6,0,1.1-0.2,1.5-0.6l0,0C4.9,4.2,5.4,4,6,4V2C5.5,2,5,1.8,4.6,1.4z"/>',
        'rb' => '<path d="M4.6,4.6C4.6,4.6,4.6,4.6,4.6,4.6C5,4.2,5.5,4,6,4V2C5.5,2,5,1.8,4.7,1.5l0,0C4.2,1,3.7,0.8,3,0.8 c-1.2,0-2.2,1-2.2,2.2c0,0.6,0.2,1.1,0.6,1.5l0,0C1.8,4.9,2,5.4,2,6h2C4,5.5,4.2,5,4.6,4.6z"/>',
        'bl' => '<path d="M1.4,4.6C1.4,4.6,1.4,4.6,1.4,4.6C1.8,5,2,5.5,2,6h2c0-0.5,0.2-1,0.5-1.3l0,0C5,4.2,5.2,3.7,5.2,3 c0-1.2-1-2.2-2.2-2.2C2.4,0.8,1.9,1,1.5,1.4l0,0C1.1,1.8,0.6,2,0,2v2C0.5,4,1,4.2,1.4,4.6z"/>',
        'tl' => '<path d="M1.4,1.4C1.4,1.4,1.4,1.4,1.4,1.4C1,1.8,0.5,2,0,2v2c0.5,0,1,0.2,1.3,0.5l0,0C1.8,5,2.3,5.2,3,5.2 c1.2,0,2.2-1,2.2-2.2c0-0.6-0.2-1.1-0.6-1.5l0,0C4.2,1.1,4,0.6,4,0H2C2,0.5,1.8,1,1.4,1.4z"/>',  
        't' => '<path d="M0.8,3c0,1.2,1,2.2,2.2,2.2s2.2-1,2.2-2.2c0-0.6-0.3-1.2-0.7-1.6C4.2,1,4,0.5,4,0H2c0,0.5-0.2,1-0.6,1.4 C1,1.8,0.8,2.4,0.8,3z"/>',
        'r' => '<path d="M3,0.8c-1.2,0-2.2,1-2.2,2.2s1,2.2,2.2,2.2c0.6,0,1.2-0.3,1.6-0.7C5,4.2,5.5,4,6,4V2C5.5,2,5,1.8,4.6,1.4 C4.2,1,3.6,0.8,3,0.8z"/>',
        'b' => '<path d="M5.2,3c0-1.2-1-2.2-2.2-2.2S0.8,1.8,0.8,3c0,0.6,0.3,1.2,0.7,1.6C1.8,5,2,5.5,2,6h2c0-0.5,0.2-1,0.6-1.4 C5,4.2,5.2,3.6,5.2,3z"/>',
        'l' => '<path d="M3,5.2c1.2,0,2.2-1,2.2-2.2S4.2,0.8,3,0.8C2.4,0.8,1.8,1,1.4,1.4C1,1.8,0.5,2,0,2v2c0.5,0,1,0.2,1.4,0.6 C1.8,5,2.4,5.2,3,5.2z"/>',
        'rotate' => false,
        'preview' => '<circle cx="5.5" cy="4.5" r="0.5"/>
    <path d="M5.8,0.2C5.7,0.2,5.6,0.1,5.5,0.1c-0.2,0-0.4,0.2-0.4,0.4s0.2,0.4,0.4,0.4c0.1,0,0.2,0,0.3-0.1
        C5.8,0.7,5.9,0.7,6,0.7V0.3C5.9,0.3,5.8,0.3,5.8,0.2z"/>
    <path d="M3.9,4.5c0-0.2-0.2-0.4-0.4-0.4c-0.1,0-0.2,0-0.3,0.1C3.2,4.3,3.1,4.3,3,4.3c-0.1,0-0.2,0-0.2-0.1 C2.7,4.2,2.6,4.1,2.5,4.1c-0.2,0-0.4,0.2-0.4,0.4c0,0.1,0,0.2,0.1,0.3C2.3,4.8,2.3,4.9,2.3,5c0,0.2-0.1,0.3-0.3,0.3c0,0,0,0-0.1,0
        C1.9,5.1,1.7,5,1.5,5S1.1,5.1,1.1,5.3c0,0,0,0-0.1,0v0c-0.1,0-0.2,0-0.2-0.1c0,0,0,0,0,0C0.7,5.2,0.7,5.1,0.7,5c0,0,0,0,0-0.1 C0.9,4.9,1,4.7,1,4.5S0.9,4.1,0.7,4.1c0,0,0,0,0-0.1h0c0-0.1,0-0.2,0.1-0.2c0.1-0.1,0.1-0.2,0.1-0.3c0-0.2-0.2-0.4-0.4-0.4 S0.1,3.3,0.1,3.5c0,0.1,0,0.2,0.1,0.3C0.3,3.8,0.3,3.9,0.3,4c0,0,0,0,0,0.1C0.1,4.1,0,4.3,0,4.5s0.1,0.4,0.3,0.4c0,0,0,0,0,0 c0,0,0,0,0,0c0,0.1,0,0.2-0.1,0.2C0.2,5.3,0.1,5.4,0.1,5.5c0,0.2,0.2,0.4,0.4,0.4c0.1,0,0.2,0,0.3-0.1C0.8,5.7,0.9,5.7,1,5.7v0 c0,0,0,0,0.1,0C1.1,5.9,1.3,6,1.5,6s0.4-0.1,0.4-0.3c0,0,0,0,0.1,0c0.2,0,0.3,0.1,0.3,0.3h0.3c0-0.2,0.1-0.3,0.3-0.3h0 c0,0,0,0,0.1,0c0.1,0,0.1,0,0.2,0.1c0,0,0,0,0,0C3.3,5.8,3.3,5.9,3.3,6h0.3c0-0.1,0-0.2,0.1-0.2c0,0,0,0,0,0 c0.1-0.1,0.1-0.2,0.1-0.3c0-0.1,0-0.2-0.1-0.3c0,0,0,0,0,0C3.7,5.2,3.7,5.1,3.7,5h0c0-0.1,0-0.2,0.1-0.2C3.8,4.7,3.9,4.6,3.9,4.5z M3.2,5.2C3.2,5.2,3.2,5.2,3.2,5.2c0,0-0.1,0.1-0.2,0.1c0,0,0,0-0.1,0h0C2.8,5.3,2.7,5.2,2.7,5c0-0.1,0-0.2,0.1-0.2c0,0,0,0,0,0 C2.8,4.7,2.9,4.7,3,4.7s0.2,0,0.2,0.1c0,0,0,0,0,0C3.3,4.8,3.3,4.9,3.3,5h0C3.3,5.1,3.3,5.2,3.2,5.2z"/>
    <path d="M5.2,2.8c0.1,0.1,0.2,0.1,0.3,0.1c0.2,0,0.4-0.2,0.4-0.4S5.7,2.1,5.5,2.1c-0.1,0-0.2,0-0.3,0.1 C5.2,2.3,5.1,2.3,5,2.3c0,0,0,0,0,0v0c0,0,0,0-0.1,0C4.9,2.1,4.7,2,4.5,2C4.3,2,4.1,2.1,4.1,2.3c0,0,0,0-0.1,0 c-0.1,0-0.2,0-0.2-0.1c0,0,0,0,0,0C3.7,2.2,3.7,2.1,3.7,2c0-0.1,0-0.2,0.1-0.2c0,0,0,0,0,0c0.1-0.1,0.1-0.2,0.1-0.3 c0-0.1,0-0.2-0.1-0.3c0,0,0,0,0,0C3.7,1.2,3.7,1.1,3.7,1c0-0.1,0-0.2,0.1-0.2c0.1-0.1,0.1-0.2,0.1-0.3c0-0.2-0.2-0.4-0.4-0.4 c-0.2,0-0.4,0.2-0.4,0.4c0,0.1,0,0.2,0.1,0.3C3.3,0.8,3.3,0.9,3.3,1c0,0.1,0,0.2-0.1,0.2c0,0,0,0,0,0C3.2,1.3,3.1,1.4,3.1,1.5 c0,0.1,0,0.2,0.1,0.3c0,0,0,0,0,0C3.3,1.8,3.3,1.9,3.3,2c0,0.1,0,0.2-0.1,0.2C3.2,2.3,3.1,2.4,3.1,2.5c0,0.2,0.2,0.4,0.4,0.4 c0.1,0,0.2,0,0.3-0.1C3.8,2.7,3.9,2.7,4,2.7c0,0,0,0,0,0l0,0c0,0,0,0,0,0c0,0,0,0,0.1,0C4.1,2.9,4.3,3,4.5,3c0.2,0,0.4-0.1,0.4-0.3 c0,0,0,0,0.1,0c0,0,0,0,0,0C5.1,2.7,5.2,2.7,5.2,2.8z"/>
    <path d="M0.5,0.9c0.1,0,0.2,0,0.3-0.1C0.8,0.7,0.9,0.7,1,0.7c0,0,0,0,0.1,0c0.1,0,0.1,0,0.2,0.1c0,0,0,0,0,0 C1.3,0.8,1.3,0.9,1.3,1h0c0,0,0,0,0,0.1C1.1,1.1,1,1.3,1,1.5s0.1,0.4,0.3,0.4c0,0,0,0,0,0.1c0,0,0,0,0,0c0,0.1,0,0.2-0.1,0.2 C1.2,2.3,1.1,2.4,1.1,2.5c0,0.2,0.2,0.4,0.4,0.4c0.2,0,0.4-0.2,0.4-0.4c0-0.1,0-0.2-0.1-0.3C1.7,2.2,1.7,2.1,1.7,2c0,0,0,0,0,0 c0,0,0,0,0,0C1.9,1.9,2,1.7,2,1.5S1.9,1.1,1.7,1.1c0,0,0,0,0-0.1v0c0-0.1,0-0.2,0.1-0.2c0,0,0,0,0,0c0.1-0.1,0.1-0.2,0.1-0.3 c0-0.1,0-0.2-0.1-0.3c0,0,0,0,0,0C1.7,0.2,1.7,0.1,1.7,0H1.3c0,0.1,0,0.2-0.1,0.2c0,0,0,0,0,0c0,0-0.1,0.1-0.2,0.1c0,0,0,0-0.1,0 c-0.1,0-0.2,0-0.2-0.1C0.7,0.2,0.6,0.1,0.5,0.1c-0.2,0-0.4,0.2-0.4,0.4S0.3,0.9,0.5,0.9z"/>',
    ),
    'special-circle-orizz' => array(
        'path' => '<circle cx="3" cy="3" r="2.5"/>',
        'trbl' => '<rect y="0.5" width="6" height="5"/>',
        'rb' => '<path d="M6,5.5H3C1.6,5.5,0.5,4.4,0.5,3v0c0-1.4,1.1-2.5,2.5-2.5h3V5.5z"/>',
        'bl' => '<path d="M3,5.5H0v-5h3c1.4,0,2.5,1.1,2.5,2.5v0C5.5,4.4,4.4,5.5,3,5.5z"/>',
        'tr' => '<path d="M6,5.5H3C1.6,5.5,0.5,4.4,0.5,3v0c0-1.4,1.1-2.5,2.5-2.5h3V5.5z"/>',
        'tl' => '<path d="M3,5.5H0v-5h3c1.4,0,2.5,1.1,2.5,2.5v0C5.5,4.4,4.4,5.5,3,5.5z"/>',
        't' => '<circle cx="3" cy="3" r="2.5"/>',
        'r' => '<path d="M6,5.5H3C1.6,5.5,0.5,4.4,0.5,3v0c0-1.4,1.1-2.5,2.5-2.5h3V5.5z"/>',
        'trb' => '<path d="M6,5.5H3C1.6,5.5,0.5,4.4,0.5,3v0c0-1.4,1.1-2.5,2.5-2.5h3V5.5z"/>',
        'b' => '<circle cx="3" cy="3" r="2.5"/>',
        'l' => '<path d="M3,5.5H0v-5h3c1.4,0,2.5,1.1,2.5,2.5v0C5.5,4.4,4.4,5.5,3,5.5z"/>',
        'tbl' => '<path d="M3,5.5H0v-5h3c1.4,0,2.5,1.1,2.5,2.5v0C5.5,4.4,4.4,5.5,3,5.5z"/>',
        'tb' => '<circle cx="3" cy="3" r="2.5"/>',
        'rl' => '<rect y="0.5" width="6" height="5"/>',
        'rotate' => false,
        'preview' => '<path d="M0.5,0.9l1,0c0.2,0,0.4-0.2,0.4-0.4c0-0.2-0.2-0.4-0.4-0.4l-1,0c-0.2,0-0.4,0.2-0.4,0.4S0.3,0.9,0.5,0.9z"/>
    <path d="M1.5,1.9l2,0c0.2,0,0.4-0.2,0.4-0.4c0-0.2-0.2-0.4-0.4-0.4l-2,0c-0.2,0-0.4,0.2-0.4,0.4S1.3,1.9,1.5,1.9z"/>
    <path d="M3.5,0.9c0.2,0,0.4-0.2,0.4-0.4c0-0.2-0.2-0.4-0.4-0.4S3.1,0.3,3.1,0.5C3.1,0.7,3.3,0.9,3.5,0.9z"/>
    <path d="M4.5,2.1l-3,0c-0.2,0-0.4,0.2-0.4,0.4s0.2,0.4,0.4,0.4l3,0c0.2,0,0.4-0.2,0.4-0.4S4.7,2.1,4.5,2.1z"/>
    <path d="M1.9,3.5c0-0.2-0.2-0.4-0.4-0.4H0v0.8h1.5C1.7,3.9,1.9,3.7,1.9,3.5z"/>
    <path d="M4.5,3.1c-0.2,0-0.4,0.2-0.4,0.4s0.2,0.4,0.4,0.4s0.4-0.2,0.4-0.4S4.7,3.1,4.5,3.1z"/>
    <path d="M5.9,4.5c0-0.2-0.2-0.4-0.4-0.4l-1,0c-0.2,0-0.4,0.2-0.4,0.4s0.2,0.4,0.4,0.4l1,0C5.7,4.9,5.9,4.7,5.9,4.5z"/>
    <path d="M3.5,4.1l-2,0c-0.2,0-0.4,0.2-0.4,0.4s0.2,0.4,0.4,0.4l2,0c0.2,0,0.4-0.2,0.4-0.4S3.7,4.1,3.5,4.1z"/>
    <path d="M2.5,5.1l-2,0c-0.2,0-0.4,0.2-0.4,0.4c0,0.2,0.2,0.4,0.4,0.4l2,0c0.2,0,0.4-0.2,0.4-0.4S2.7,5.1,2.5,5.1z"/>
    <path d="M6,0.1l-1.5,0c-0.2,0-0.4,0.2-0.4,0.4s0.2,0.4,0.4,0.4l1.5,0h0L6,0.1L6,0.1z"/>
    <path d="M5.1,5.5c0,0.2,0.2,0.4,0.4,0.4H6V5.1H5.5C5.3,5.1,5.1,5.3,5.1,5.5z"/>',
    ),
    'special-circle-vert' => array(
        'path' => '<circle cx="3" cy="3" r="2.5"/>',
        'trbl' => '<rect x="0.5" width="5" height="6"/>',
        'rb' => '<path d="M5.5,6h-5V3c0-1.4,1.1-2.5,2.5-2.5h0c1.4,0,2.5,1.1,2.5,2.5V6z"/>',
        'bl' => '<path d="M5.5,6h-5V3c0-1.4,1.1-2.5,2.5-2.5h0c1.4,0,2.5,1.1,2.5,2.5V6z"/>',
        'tr' => '<path d="M3,5.5L3,5.5C1.6,5.5,0.5,4.4,0.5,3V0h5v3C5.5,4.4,4.4,5.5,3,5.5z"/>',
        'tl' => '<path d="M3,5.5L3,5.5C1.6,5.5,0.5,4.4,0.5,3V0h5v3C5.5,4.4,4.4,5.5,3,5.5z"/>',
        't' => '<path d="M3,5.5L3,5.5C1.6,5.5,0.5,4.4,0.5,3V0h5v3C5.5,4.4,4.4,5.5,3,5.5z"/>',
        'r' => '<circle cx="3" cy="3" r="2.5"/>',
        'rbl' => '<path d="M5.5,6h-5V3c0-1.4,1.1-2.5,2.5-2.5h0c1.4,0,2.5,1.1,2.5,2.5V6z"/>',
        'b' => '<path d="M5.5,6h-5V3c0-1.4,1.1-2.5,2.5-2.5h0c1.4,0,2.5,1.1,2.5,2.5V6z"/>',
        'l' => '<circle cx="3" cy="3" r="2.5"/>',
        'trl' => '<path d="M3,5.5L3,5.5C1.6,5.5,0.5,4.4,0.5,3V0h5v3C5.5,4.4,4.4,5.5,3,5.5z"/>',
        'tb' => '<rect x="0.5" width="5" height="6"/>',
        'rl' => '<circle cx="3" cy="3" r="2.5"/>',
        'rotate' => false,
        'preview' => '<path d="M0.5,4.1c-0.2,0-0.4,0.2-0.4,0.4l0,1c0,0.2,0.2,0.4,0.4,0.4s0.4-0.2,0.4-0.4l0-1C0.9,4.3,0.7,4.1,0.5,4.1z"/>
    <path d="M1.5,2.1c-0.2,0-0.4,0.2-0.4,0.4l0,2c0,0.2,0.2,0.4,0.4,0.4s0.4-0.2,0.4-0.4l0-2C1.9,2.3,1.7,2.1,1.5,2.1z"/>
    <path d="M0.5,2.9c0.2,0,0.4-0.2,0.4-0.4S0.7,2.1,0.5,2.1c-0.2,0-0.4,0.2-0.4,0.4S0.3,2.9,0.5,2.9z"/>
    <path d="M2.5,1.1c-0.2,0-0.4,0.2-0.4,0.4l0,3c0,0.2,0.2,0.4,0.4,0.4s0.4-0.2,0.4-0.4l0-3C2.9,1.3,2.7,1.1,2.5,1.1z"/>
    <path d="M3.5,4.1c-0.2,0-0.4,0.2-0.4,0.4V6h0.8V4.5C3.9,4.3,3.7,4.1,3.5,4.1z"/>
    <path d="M3.5,1.1c-0.2,0-0.4,0.2-0.4,0.4s0.2,0.4,0.4,0.4s0.4-0.2,0.4-0.4S3.7,1.1,3.5,1.1z"/>
    <path d="M4.5,1.9c0.2,0,0.4-0.2,0.4-0.4l0-1c0-0.2-0.2-0.4-0.4-0.4c-0.2,0-0.4,0.2-0.4,0.4l0,1 C4.1,1.7,4.3,1.9,4.5,1.9z"/>
    <path d="M4.5,2.1c-0.2,0-0.4,0.2-0.4,0.4l0,2c0,0.2,0.2,0.4,0.4,0.4s0.4-0.2,0.4-0.4l0-2C4.9,2.3,4.7,2.1,4.5,2.1z"/>
    <path d="M5.5,3.1c-0.2,0-0.4,0.2-0.4,0.4l0,2c0,0.2,0.2,0.4,0.4,0.4c0.2,0,0.4-0.2,0.4-0.4l0-2 C5.9,3.3,5.7,3.1,5.5,3.1z"/>
    <path d="M0.1,0l0,1.5c0,0.2,0.2,0.4,0.4,0.4s0.4-0.2,0.4-0.4l0-1.5v0L0.1,0L0.1,0z"/>
    <path d="M5.5,0.9c0.2,0,0.4-0.2,0.4-0.4V0H5.1v0.5C5.1,0.7,5.3,0.9,5.5,0.9z"/>',
    ),
    'special-circle' => array(
        'path' => '<circle cx="3" cy="3" r="3"/>',
        'tb' => '<rect width="6" height="6"/>',
        'rl' => '<rect width="6" height="6"/>',
        'trbl' => '<rect width="6" height="6"/>',
        'rb' => '<path d="M6,6H0V3c0-1.7,1.3-3,3-3l3,0V6z"/>',
        'bl' => '<path d="M6,6H0V0l3,0c1.7,0,3,1.3,3,3V6z"/>',
        'tr' => '<path d="M6,6H3C1.3,6,0,4.7,0,3V0l6,0V6z"/>',
        'tl' => '<path d="M3,6H0V0l6,0v3C6,4.7,4.7,6,3,6z"/>',
        't' => '<path d="M3,6L3,6C1.3,6,0,4.7,0,3V0h6v3C6,4.7,4.7,6,3,6z"/>',
        'r' => '<path d="M6,6H3C1.3,6,0,4.7,0,3v0c0-1.7,1.3-3,3-3h3C6,0,6,6,6,6z"/>',
        'b' => '<path d="M6,6H0V3c0-1.7,1.3-3,3-3h0c1.7,0,3,1.3,3,3V6z"/>',
        'l' => '<path d="M3,6H0V0l3,0c1.7,0,3,1.3,3,3v0C6,4.7,4.7,6,3,6z"/>',
        'rotate' => false,
        'preview' => '<path d="M2.5,3C2.8,3,3,2.8,3,2.5L3,2h1.5C4.8,2,5,1.8,5,1.5C5,1.2,4.8,1,4.5,1H4V0L2,0l0,2.5C2,2.8,2.2,3,2.5,3z M4,1 L4,1L4,1L4,1z"/>
<path d="M5.5,3C5.2,3,5,3.2,5,3.5S5.2,4,5.5,4C5.8,4,6,3.8,6,3.5S5.8,3,5.5,3z"/>
<path d="M0.5,1C0.8,1,1,0.8,1,0.5V0L0,0v0v0.5C0,0.8,0.2,1,0.5,1z"/>
<path d="M4,4L4,4L3,4l0,0v0C2.4,4,2,4.4,2,5h0H1V2.5C1,2.2,0.8,2,0.5,2S0,2.2,0,2.5V5h0c0,0.6,0.4,1,1,1h2v0V5h1v0h0v1 l1,0V5h0C5,4.4,4.6,4,4,4z"/>',
    ),
    'special-diamond' => array(
        'path' => '<polyline points="6,3 3,6 0,3 3,0 "/>',
        'trbl' => '<rect width="6" height="6"/>',
        'tb' => '<rect width="6" height="6"/>',
        'rl' => '<rect width="6" height="6"/>',        
        'rb' => '<polygon points="3,0 6,0 6,3 6,6 3,6 0,6 0,3 "/>',
        'bl' => '<polygon points="6,3 6,6 3,6 0,6 0,3 0,0 3,0 "/>',
        'tr' => '<polygon points="0,3 0,0 3,0 6,0 6,3 6,6 3,6 "/>',
        'tl' => '<polygon points="3,6 0,6 0,3 0,0 3,0 6,0 6,3 "/>',
        't' => '<polygon points="6,3 3,6 0,3 0,3 0,0 3,0 6,0 6,3 "/>',
        'r' => '<polygon points="6,6 3,6 3,6 0,3 3,0 3,0 6,0 6,3 "/>',
        'b' => '<polygon points="6,6 3,6 0,6 0,3 0,3 3,0 6,3 6,3 "/>',
        'l' => '<polygon points="3,6 3,6 0,6 0,3 0,0 3,0 3,0 6,3 "/>',
        'rotate' => false,
        'preview' => '<rect x="4.1" y="3.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -1.1563 4.2076)" width="0.7" height="0.7"/>
<polygon points="1,1.5 1,1 1,1 2.5,1 3,0.5 2.5,0 0.5,0 0,0.5 0,1.5 0.5,2 "/>
<path d="M3,2"/>
<rect x="5.1" y="4.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -1.5707 5.2069)" width="0.7" height="0.7"/>
<polygon points="0.5,3 0,3.5 0,5.5 0.5,6 1,5.5 1,4 2,4 2,5.5 2.5,6 4.5,6 5,5.5 4.5,5 3,5 3,3.5 2.5,3"/>
<polygon points="5.5,0 4.5,0 4,0.5 4,1 3.5,1 3,1.5 3,2.5 3.5,3 4,2.5 4,2 4.5,2 5,1.5 5,1 5.5,1 6,0.5"/>',
    ),
    'ribbon' => array(
        'path' => '<rect width="6" height="6"/>',
        'rotate' => false,
        't' => '<polygon points="6,6 3,3 0,6 0,0 6,0 "/>',
        'r' => '<polygon points="6,6 0,6 3,3 0,0 6,0 "/>',
        'b' => '<polygon points="6,6 0,6 0,0 3,3 6,0 "/>',
        'l' => '<polygon points="6,6 0,6 0,0 6,0 3,3 "/>',
        'preview' => '<rect x="4" y="3" width="1" height="1"/>
    <rect x="5" y="4" width="1" height="1"/>
    <polygon points="5,1 6,1 6,1 6,1 5.5,0.5 6,0 4,0 4,0 4,0 4,1 4,1 4,1 3,1 2.5,0.5 3,0 3,0 3,0 0,0 0,2 0,2 0,2 0.5,1.5 1,2 1,2 1,2 1,1 1,1 3,1 3,3 0,3 0,6 0,6 0,6 0.5,5.5 1,6 1,6 1,4 2,4 2,6 6,6 6,6 5,6 4.5,5.5 5,5 5,5 5,5 3,5 3,3 3.5,2.5 4,3 4,3 4,3 4,2 5,2 5,2 5,2"/>',
    ),
    'oriental' => array(
        'path' => '<circle cx="3" cy="3" r="3"/>',
        'tb' => '<rect width="6" height="6"/>',
        'rl' => '<rect width="6" height="6"/>',
        'trbl' => '<rect width="6" height="6"/>',
        'rb' => '<path d="M6,6H0V3c0-1.7,1.3-3,3-3l3,0V6z"/>',
        'bl' => '<path d="M6,6H0V0l3,0c1.7,0,3,1.3,3,3V6z"/>',
        'tr' => '<path d="M6,6H3C1.3,6,0,4.7,0,3V0l6,0V6z"/>',
        'tl' => '<path d="M3,6H0V0l6,0v3C6,4.7,4.7,6,3,6z"/>',
        't' => '<path d="M0,0l0.4,1.3c0.4,1.1,0.4,2.4,0,3.5L0,6c3.3,0,6-2.7,6-6H0z"/>',
        'r' => '<path d="M4.7,0.4c-1.1,0.4-2.4,0.4-3.5,0L0,0c0,3.3,2.7,6,6,6V0L4.7,0.4z"/>',
        'b' => '<path d="M6,6H0v0c0-3.3,2.7-6,6-6h0L5.6,1.3c-0.4,1.1-0.4,2.4,0,3.5L6,6z"/>',
        'l' => '<path d="M0,0v6l1.3-0.4c1.1-0.4,2.4-0.4,3.5,0L6,6C6,2.7,3.3,0,0,0z"/>',
        'rotate' => false,
        'preview' => '<path d="M5.5,4C5.2,4,5,4.2,5,4.5S5.2,5,5.5,5C5.8,5,6,4.8,6,4.5S5.8,4,5.5,4z"/>
<path d="M0,2c0.6,0,1-0.4,1-1l1,0v0l0.2-0.1c0.2-0.1,0.4-0.1,0.6,0L3,1c0,0,0,0,0,0v0l0,0c0-0.6-0.4-1-1-1v0H0l0,1h0l0.1,0.2 c0.1,0.2,0.1,0.4,0,0.6L0,2z"/>
<path d="M4.5,3C4.2,3,4,3.2,4,3.5S4.2,4,4.5,4C4.8,4,5,3.8,5,3.5S4.8,3,4.5,3z"/>
<path d="M3,2L3,2L3,2l0.1,0.2c0.1,0.2,0.1,0.4,0,0.6L3,3c0.6,0,1-0.4,1-1l0,0h0h0.5C4.8,2,5,1.8,5,1.5V1l0.2-0.1 c0.2-0.1,0.4-0.1,0.6,0L6,1c0-0.6-0.4-1-1-1l0,0h0H4.5C4.2,0,4,0.2,4,0.5V1h0H3.5C3.2,1,3,1.2,3,1.5V2z"/>
<path d="M4,5L4,5L3,5v0h0l0-1.5C3,3.2,2.8,3,2.5,3l-1,0C1.2,3,1,3.2,1,3.5L1,4l0,0L0.8,4.1c-0.2,0.1-0.4,0.1-0.6,0L0,4 c0,0.6,0.4,1,1,1l0,0l1,0l0,0.5C2,5.8,2.2,6,2.5,6L4,6l0,0v0l0.2-0.1c0.2-0.1,0.4-0.1,0.6,0L5,6C5,5.4,4.6,5,4,5z"/>',
    ),
    'ellipse' => array(
        'path' => '<path d="M5.4,2.8C4.5,1.1,2.6-0.1,1.2,0c-1.3,0.1-1.6,1.6-0.7,3.2c1,1.7,2.8,2.9,4.2,2.8C6.1,5.9,6.4,4.4,5.4,2.8z"/>',
        'tb' => '<rect width="6" height="6"/>',
        'rl' => '<rect width="6" height="6"/>',
        'trbl' => '<rect width="6" height="6"/>',
        'rb' => '<path d="M6,6H0V2c0-1.1,0.9-2,2-2h4V6z"/>',
        'bl' => '<path d="M0,6V0h4c1.1,0,2,0.9,2,2v4H0z"/>',
        'tr' => '<path d="M6,0v6H2C0.9,6,0,5.1,0,4V0H6z"/>',
        'tl' => '<path d="M0,0h6v4c0,1.1-0.9,2-2,2H0V0z"/>',
        't' => '<path d="M5.2,6L5.2,6C3.8,6,0,1.4,0,0l0,0h6v5.2C6,5.6,5.6,6,5.2,6z"/>',
        'r' => '<path d="M0,5.2L0,5.2C0,3.8,4.6,0,6,0l0,0v6H0.8C0.4,6,0,5.6,0,5.2z"/>',
        'b' => '<path d="M0.8,0L0.8,0C2.2,0,6,4.6,6,6l0,0H0V0.8C0,0.4,0.4,0,0.8,0z"/>',
        'l' => '<path d="M6,0.8L6,0.8C6,2.2,1.4,6,0,6l0,0V0h5.2C5.6,0,6,0.4,6,0.8z"/>',
        'rotate' => false,
        'preview' => '<path d="M5.2,4C5,4,4.9,4.3,5.1,4.5C5.3,4.8,5.6,5,5.8,5C6,5,6.1,4.7,5.9,4.5C5.7,4.2,5.4,4,5.2,4z"/>
    <path d="M5,0.9C5,0.9,5.1,1,5.1,1H6V0C5.8,0,5,0.6,5,0.9z"/>
    <path d="M5.9,2H4l0,0h0V1l0,0h0c0-0.2-0.6-1-0.9-1C3.1,0,3,0.1,3,0.1v2.5C3,2.9,3.1,3,3.3,3L5,3v0l0,0c0.2,0,1-0.6,1-0.9 C6,2.1,5.9,2,5.9,2z"/>
    <path d="M3.7,4H2.3C2.1,4,2,4.1,2,4.3V5h0l0,0H1v0V4h0l0,0c0-0.2-0.6-1-0.9-1C0.1,3,0,3.1,0,3.1v2.5C0,5.9,0.1,6,0.3,6L4,6V4.3 C4,4.1,3.9,4,3.7,4z"/>
    <path d="M0.1,1H1v0v1h0l0,0c0,0.2,0.6,1,0.9,1C1.9,3,2,2.9,2,2.9L2,0H1v0C0.8,0,0,0.6,0,0.9C0,0.9,0.1,1,0.1,1z"/>',
    ),
    'vortex' => array(
        'path' => '<path d="M3.5,6C0.7,4.7,1.7,3,0,3.5C1.3,0.7,3,1.7,2.5,0C5.3,1.3,4.3,3,6,2.5C4.7,5.3,3,4.3,3.5,6z"/>',
        'rotate' => false,
        'marker' => true,
    ),
    'sparkle_dot' => array(
        'path' => '<path d="M3-1L3-1c0,2.2-1.8,4-4,4h0h0c2.2,0,4,1.8,4,4v0v0c0-2.2,1.8-4,4-4h0h0C4.8,3,3,1.2,3-1L3-1z"/>',
        'rotate' => false,
        'marker' => true,
    ),
    '9-dots' => array(
        'path' => '<circle cx="1" cy="1" r="1"/><circle cx="3" cy="1" r="1"/><circle cx="5" cy="1" r="1"/><circle cx="1" cy="3" r="1"/><circle cx="3" cy="3" r="1"/><circle cx="5" cy="3" r="1"/><circle cx="1" cy="5" r="1"/><circle cx="3" cy="5" r="1"/><circle cx="5" cy="5" r="1"/>',
        'rotate' => false,
        'marker' => true,
    ),
    '9-dots-fat' => array(
        'path' => '<path d="M6,3c0-0.4-0.3-0.8-0.6-1C5.7,1.9,6,1.5,6,1.1C6,0.5,5.5,0,4.9,0C4.5,0,4.1,0.3,4,0.6C3.8,0.3,3.4,0,3,0S2.2,0.3,2,0.6 C1.9,0.3,1.5,0,1.1,0C0.5,0,0,0.5,0,1.1c0,0.4,0.3,0.8,0.6,1C0.3,2.2,0,2.6,0,3s0.3,0.8,0.6,1C0.3,4.1,0,4.5,0,4.9 C0,5.5,0.5,6,1.1,6c0.4,0,0.8-0.3,1-0.6C2.2,5.7,2.6,6,3,6s0.8-0.3,1-0.6C4.1,5.7,4.5,6,4.9,6C5.5,6,6,5.5,6,4.9 c0-0.4-0.3-0.8-0.6-1C5.7,3.8,6,3.4,6,3z"/>',
        'rotate' => false,
        'marker' => true,
    ),
    'flower' => array(
        'path' => '<path d="M4.3,6H1.7C0.8,6,0,5.2,0,4.3V0h4.3C5.2,0,6,0.8,6,1.7v2.6C6,5.2,5.2,6,4.3,6z"/>',
        'rotate' => true,
        'marker' => true,
    ),
    'elastic' => array(
        'path' => '<path d="M6,6L6,6C4.1,5.4,1.9,5.4,0,6l0,0l0,0c0.6-1.9,0.6-4.1,0-6l0,0l0,0c1.9,0.6,4.1,0.6,6,0l0,0l0,0C5.4,1.9,5.4,4.1,6,6L6,6z"/>',
        'rotate' => false,
        'marker' => true,
    ),
    'diagonal' => array(
        'path' => '<polygon points="6,6 3,6 0,3 0,0 3,0 6,3 "/>',
        'rotate' => true,
        'marker' => true,
    ),
    'ropes' => array(
        'path' => '<path d="M5.1,1.9H0.9C0.4,1.9,0,1.5,0,1v0c0-0.5,0.4-0.9,0.9-0.9h4.2C5.6,0.1,6,0.5,6,1v0C6,1.5,5.6,1.9,5.1,1.9z"/><path d="M5.1,3.9H0.9C0.4,3.9,0,3.5,0,3v0c0-0.5,0.4-0.9,0.9-0.9h4.2C5.6,2.1,6,2.5,6,3v0C6,3.5,5.6,3.9,5.1,3.9z"/><path d="M5.1,5.9H0.9C0.4,5.9,0,5.5,0,5v0c0-0.5,0.4-0.9,0.9-0.9h4.2C5.6,4.1,6,4.5,6,5v0C6,5.5,5.6,5.9,5.1,5.9z"/>',
        'rotate' => false,
        'marker' => true,
    ),
    'ropes-vert' => array(
        'path' => '<path d="M4.1,5.1V0.9C4.1,0.4,4.5,0,5,0h0c0.5,0,0.9,0.4,0.9,0.9v4.2C5.9,5.6,5.5,6,5,6h0C4.5,6,4.1,5.6,4.1,5.1z"/><path d="M2.1,5.1V0.9C2.1,0.4,2.5,0,3,0h0c0.5,0,0.9,0.4,0.9,0.9v4.2C3.9,5.6,3.5,6,3,6h0C2.5,6,2.1,5.6,2.1,5.1z"/><path d="M0.1,5.1V0.9C0.1,0.4,0.5,0,1,0h0c0.5,0,0.9,0.4,0.9,0.9v4.2C1.9,5.6,1.5,6,1,6h0C0.5,6,0.1,5.6,0.1,5.1z"/>',
        'rotate' => false,
        'marker' => true,
    ),
    'bruised' => array(
        'path' => '<path d="M1.5,6C1.2,5.3,0.7,4.8,0,4.5v-3C0,0.7,0.7,0,1.5,0h3C4.8,0.7,5.3,1.2,6,1.5v3C6,5.3,5.3,6,4.5,6H1.5z"/>',
        'rotate' => true,
        'marker' => true,
    ),
);
